<?php
include("config.php");

$db = new DB_Connect();
$con = $db->connect();

$lyricistName = strtolower(trim($_POST["lyricistName"]));

$sql_query = "SELECT 
				lm.id AS lyricist_id,
				lm.lyricist_name,

                (SELECT COUNT(DISTINCT sm.movie_id) 
                    FROM song_master AS sm
                    WHERE sm.lyricist_id = lm.lyricist_id)
                    AS total_movies,

                 (SELECT COUNT(DISTINCT sm.song_id) 
                    FROM song_master AS sm
                    WHERE sm.composer_id = lm.composer_id)
                    AS total_songs
                
				
			FROM lyricist_master AS lm
            WHERE REGEXP_REPLACE(LOWER(lm.lyricist_name), '[^a-z]', '') 
            LIKE CONCAT('%', REGEXP_REPLACE(LOWER('$lyricistName'), '[^a-z]', ''), '%')
            ORDER BY lm.lyricist_name ASC";

$res = mysqli_query($con, $sql_query);

$result = array('status'=>false, "msg"=>"No Data Available", "lyricists"=>[]);

while($row = mysqli_fetch_array($res)){
    $result['lyricists'][] = array(
							'0'=>$row['lyricist_id'],
                            '1'=>$row['lyricist_name'],
                            '2'=>$row['total_movies'],
                            '3'=>$row['total_songs'],
						);
}

if (!empty($result['lyricists'])) {
	 $result['status'] = true;
	 $result['msg'] = "Data is Available";
} else {
    unset($result['lyricists']);
}

echo json_encode($result);

mysqli_close($con);
?>