<?php
include("config.php");

$db = new DB_Connect();
$con = $db->connect();

$composerName = strtolower(trim($_POST["composerName"]));

$sql_query = "SELECT 
				cm.id AS composer_id,
				cm.composer_name,

                (SELECT COUNT(DISTINCT sm.movie_id) 
                    FROM song_master AS sm
                    WHERE sm.composer_id = cm.composer_id)
                    AS total_movies,

                 (SELECT COUNT(DISTINCT sm.song_id) 
                    FROM song_master AS sm
                    WHERE sm.composer_id = cm.composer_id)
                    AS total_songs
                
				
			FROM composer_master AS cm
            WHERE REGEXP_REPLACE(LOWER(cm.composer_name), '[^a-z]', '') 
            LIKE CONCAT('%', REGEXP_REPLACE(LOWER('$composerName'), '[^a-z]', ''), '%')
            ORDER BY cm.composer_name ASC";

$res = mysqli_query($con, $sql_query);

$result = array('status'=>false, "msg"=>"No Data Available", "composers"=>[]);

while($row = mysqli_fetch_array($res)){
    $result['composers'][] = array(
							'0'=>$row['composer_id'],
                            '1'=>$row['composer_name'],
                            '2'=>$row['total_movies'],
                            '3'=>$row['total_songs'],
						);
}

if (!empty($result['composers'])) {
	 $result['status'] = true;
	 $result['msg'] = "Data is Available";
} else {
    unset($result['composers']);
}

echo json_encode($result);

mysqli_close($con);
?>