<?php
include("config.php");

$db = new DB_Connect();
$con = $db->connect();

if (isset($_POST['userId'])) {
    $userId = $_POST['userId'];

    // Prepare the query to prevent SQL injection
    $sql_query = "SELECT * FROM `user_master` WHERE `user_name` = :userId";

    // Prepare the statement
    $stmt = $con->prepare($sql_query);
    $stmt->bindParam(':userId', $userId, PDO::PARAM_STR);

    try {
        // Execute the statement
        $stmt->execute();

        // Check if user is found
        $result = array("status" => "false");

        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            // Populate result if found
            $result = array(
                "status" => "true",
                "name" => $row["name"],
                "userName" => $row["user_name"],
                "email" => $row["email"],
                "title" => $row["title"],
                "gender" => $row["gender"],
                "dateOfBirth" => $row["date_of_birth"],
                "mobileNo" => $row["mobile_no"],
                "experience" => $row["experience"],
                "tamil" => $row["tamil"],
                "malayalam" => $row["malayalam"],
                "hindi" => $row["hindi"]
            );
        }

        echo json_encode($result);

    } catch (PDOException $e) {
        // Handle any errors that occur during query execution
        echo json_encode(array("status" => "error", "message" => $e->getMessage()));
    }

} else {
    echo json_encode(array("status" => "error", "message" => "userId is missing"));
}

// Close connection (optional for PDO, it closes automatically at the end of script)
$con = null;
?>
