<?php
include("config.php");

try {
    // Connect to the database using PDO
    $db = new DB_Connect();
    $con = $db->connect();

    // Retrieve POST data
    $index = $_POST["index"] ?? null;
    $limit = $_POST["limit"] ?? null;

    if (!isset($index, $limit)) {
        echo json_encode(['status' => false, 'message' => 'Missing index or limit']);
        exit;
    }

    // SQL query with placeholders
    $sql_query = "SELECT mov.id AS movie_id, 
                        mov.movie_name,
                        mov.year,
                        (SELECT COUNT(*) 
                         FROM song_master sm 
                         WHERE sm.movie_id = mov.id) AS number_of_songs
                  FROM movies mov
                  ORDER BY mov.movie_name ASC
                  LIMIT :index, :limit";

    // Prepare the statement
    $stmt = $con->prepare($sql_query);

    // Bind parameters
    $stmt->bindParam(':index', $index, PDO::PARAM_INT);
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Initialize the result array
    $result = ['status' => false, 'movies' => []];

    // Fetch all rows
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $result['status'] = true;
        $result['movies'][] = [
            '0' => $row["movie_id"],
            '1' => $row['movie_name'],
            '2' => $row['year'],
            '3' => $row['number_of_songs'],
        ];
    }

    // Output the result as JSON
    echo json_encode([$result]);

} catch (PDOException $e) {
    // Handle database errors
    echo json_encode(['status' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
