<?php
include("config.php");

try {
    // Connect to the database using PDO
    $db = new DB_Connect();
    $con = $db->connect();

    // Retrieve POST data
    $composerId = $_POST["composerId"] ?? null;
    $languageId = $_POST["languageId"] ?? null;

    if (!$composerId || !$languageId) {
        echo json_encode(['status' => false, 'message' => 'Missing composerId or languageId']);
        exit;
    }

    // SQL query with placeholders
    $sql_query = "SELECT mov.id AS movie_id, 
                        mov.movie_name,
                        mov.year,
                        (SELECT COUNT(*) 
                            FROM song_master sm 
                            WHERE sm.movie_id = mov.id) AS number_of_songs,
                        mov.language_id
                  FROM movie_composer mov_com
                  INNER JOIN movies mov ON mov.id = mov_com.movie_id
                  WHERE mov_com.composer_id = :composerId 
                        AND mov.language_id = :languageId
                  ORDER BY mov.movie_name ASC";

    // Prepare the statement
    $stmt = $con->prepare($sql_query);

    // Bind parameters
    $stmt->bindParam(':composerId', $composerId, PDO::PARAM_INT);
    $stmt->bindParam(':languageId', $languageId, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Initialize the result array
    $result = ['status' => false, 'movies' => []];

    // Fetch all rows
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $result['status'] = true;
        $result['movies'][] = [
            '0' => $row["movie_id"],
            '1' => $row['movie_name'],
            '2' => $row['year'],
            '3' => $row['number_of_songs'],
        ];
    }

    // Output the result as JSON
    echo json_encode($result);

} catch (PDOException $e) {
    // Handle database errors
    echo json_encode(['status' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
