<?php
session_start();
include("include/config.php");

$otp_error = "";

if (!isset($_SESSION['otp_user_id'])) {
    header("Location: login.php");
    exit();
}

if (isset($_POST['verify'])) {
    $userOtp = trim($_POST['otp']);
    $storedOtp = $_SESSION['otp_code'];
    $otpTime = $_SESSION['otp_time'];

    if ((time() - $otpTime) > 300) { // OTP expires in 5 minutes
        $otp_error = "OTP expired. Please login again.";
        session_unset();
        session_destroy();
    } else if ($userOtp == $storedOtp) {
        // OTP verified
        $_SESSION['id'] = $_SESSION['otp_user_id'];
        $_SESSION['login'] = $_SESSION['otp_email'];

        // Clear OTP session
        unset($_SESSION['otp_user_id'], $_SESSION['otp_email'], $_SESSION['otp_code'], $_SESSION['otp_time']);

        // Clear OTP in DB
        $stmt = $con->prepare("UPDATE users SET otp = NULL WHERE id = ?");
        $stmt->bind_param("i", $_SESSION['id']);
        $stmt->execute();

        header("Location: dashboard.php");
        exit();
    } else {
        $otp_error = "Incorrect OTP. Try again.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>OTP Verification</title>
<style>
body { font-family: Arial,sans-serif; background:#f4f4f9; display:flex; justify-content:center; align-items:center; height:100vh; }
.otp-box { background:#fff; padding:30px; border-radius:10px; box-shadow:0 4px 8px rgba(0,0,0,0.1); width:400px; max-width:95%; text-align:center; }
input { width:80%; padding:12px; border:1px solid #ddd; border-radius:5px; margin:15px 0; font-size:14px; }
button { padding:12px 20px; background:#3498db; color:#fff; border:none; border-radius:5px; cursor:pointer; }
button:hover { background:#2980b9; }
.error { color:red; font-size:13px; margin-top:10px; }
</style>
</head>
<body>
<div class="otp-box">
<h2>Enter OTP</h2>
<?php if(!empty($otp_error)) echo "<div class='error'>$otp_error</div>"; ?>
<form method="POST">
<input type="text" name="otp" placeholder="Enter OTP" required>
<br>
<button type="submit" name="verify">Verify OTP</button>
</form>
</div>
</body>
</html>
