<?php  
session_start();
include('include/config.php');
include('include/checklogin.php');
check_login();

$userId = $_SESSION['id']; // Logged-in user ID

// Fetch only this user's records
$sql = mysqli_query($con, "SELECT * FROM users WHERE id = '$userId'");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Patient | View Patients Medical History</title>
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="vendor/fontawesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="vendor/themify-icons/themify-icons.css" rel="stylesheet">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">        
    <?php include('include/sidebar.php'); ?>

    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                
                <!-- start: PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Patient | View Patients Medical History</h1>
                        </div>
                    </div>
                </section>
                
                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <h5 class="over-title margin-bottom-15">View <span class="text-bold">Patients</span></h5>
                            
                            <table class="table table-striped table-bordered" id="example1">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Patient Name</th>
                                        <th>Address</th>
                                        <th>City</th>
                                        <th>Gender</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cnt = 1;
                                    while ($row = mysqli_fetch_array($sql)) {
                                    ?>
                                    <tr>
                                        <td><?= $cnt++; ?>.</td>
                                        <td><?= htmlentities($row['fullName']); ?></td>
                                        <td><?= htmlentities($row['address']); ?></td>
                                        <td><?= htmlentities($row['city']); ?></td>
                                        <td><?= htmlentities($row['gender']); ?></td>
                                        <td>
                                            <a href="view-patient.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-primary" title="View Patient Details">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- end app-content -->

    <!-- ✅ Footer outside app-content -->
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>

</div><!-- end app -->

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>

<!-- DataTables -->
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function () {
        $('#example1').DataTable();
    });
</script>

<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function() {
        Main.init();
    });
</script>
</body>
</html>
