<?php
session_start();
include('include/config.php');
error_reporting(0);

if (!isset($_SESSION['id'])) {
    echo "<script>alert('Please login to edit profile'); window.location.href='login.php';</script>";
    exit();
}

$userId = intval($_SESSION['id']);
$stmt = $con->prepare("SELECT * FROM users WHERE id=?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "<script>alert('Invalid user'); window.location.href='dashboard.php';</script>";
    exit();
}

// Handle form submit
if (isset($_POST['submit'])) {
    $fname      = trim($_POST['fname']);
    $address    = trim($_POST['address']);
    $city       = trim($_POST['city']);
    $gender     = $_POST['gender'];
    $age        = intval($_POST['age']);
    $bloodgroup = $_POST['bloodgroup'];
    $country    = $_POST['country'];
    $state      = $_POST['state'];
    $pincode    = trim($_POST['pincode']);
    $email      = trim($_POST['email']);
    $dob        = $_POST['dob'];
    $mobile_no  = trim($_POST['mobile_no']);
    $profile_pic = $user['profile_pic'];

    // Profile pic upload
    if (!empty($_FILES['profile_pic']['name'])) {
        $targetDir = "uploads/";
        if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

        $fileName = time() . '_' . basename($_FILES["profile_pic"]["name"]);
        $targetFilePath = $targetDir . $fileName;
        $fileType = strtolower(pathinfo($targetFilePath, PATHINFO_EXTENSION));
        $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];

        if (in_array($fileType, $allowedTypes)) {
            if (move_uploaded_file($_FILES["profile_pic"]["tmp_name"], $targetFilePath)) {
                $profile_pic = $fileName;
            } else {
                echo "<script>alert('Error uploading image.'); window.history.back();</script>";
                exit();
            }
        } else {
            echo "<script>alert('Only JPG, JPEG, PNG, GIF allowed.'); window.history.back();</script>";
            exit();
        }
    }

    $update = $con->prepare("UPDATE users 
        SET fullName=?, address=?, city=?, gender=?, age=?, bloodgroup=?, country=?, state=?, pincode=?, 
            email=?, dob=?, mobile_no=?, profile_pic=?, updationDate=NOW() 
        WHERE id=?");
    $update->bind_param(
        "ssssissssssssi",
        $fname,
        $address,
        $city,
        $gender,
        $age,
        $bloodgroup,
        $country,
        $state,
        $pincode,
        $email,
        $dob,
        $mobile_no,
        $profile_pic,
        $userId
    );
    if ($update->execute()) {
        echo "<script>alert('Profile updated successfully!'); window.location.href='edit-profile.php';</script>";
        exit();
    } else {
        echo "<script>alert('Update failed. Try again.'); window.history.back();</script>";
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patient Edit Profile</title>
  <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
  <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
  <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="shortcut icon" href="assets/images/favicon.png" />
  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
</head>
<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>
        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Patient | Edit Profile</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container-fluid bg-white">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-white">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">Edit Profile</h5>
                                    </div>
                                    <div class="panel-body">
                                        <form method="post" enctype="multipart/form-data">
                                            <div class="mb-3 text-center">
                                                <label>Profile Picture</label><br>
                                                <?php if (!empty($user['profile_pic'])): ?>
                                                    <img src="uploads/<?php echo htmlentities($user['profile_pic']); ?>" style="width:100px;height:100px;border-radius:50%;">
                                                <?php else: ?>
                                                    <img src="assets/img/default-avatar.png" style="width:100px;height:100px;border-radius:50%;">
                                                <?php endif; ?>
                                                <input type="file" name="profile_pic" class="form-control mt-2" accept="image/*">
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label>Full Name</label>
                                                    <input type="text" name="fname" class="form-control"
                                                        value="<?php echo htmlentities($user['fullName']); ?>" required
                                                        onkeypress="return /[a-zA-Z\s]/.test(event.key);">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Username (Read-only)</label>
                                                    <input type="text" class="form-control"
                                                        value="<?php echo htmlentities($user['username']); ?>" readonly>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Email</label>
                                                    <input type="email" name="email" class="form-control"
                                                        value="<?php echo htmlentities($user['email']); ?>" required>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Date of Birth</label>
                                                    <input type="date" name="dob" class="form-control"
                                                        value="<?php echo htmlentities($user['dob']); ?>">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Age</label>
                                                    <input type="text" name="age" class="form-control"
                                                        value="<?php echo htmlentities($user['age']); ?>" required
                                                        onkeypress="return /[0-9]/.test(event.key);">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Mobile Number</label>
                                                    <input type="text" name="mobile_no" class="form-control"
                                                        value="<?php echo htmlentities($user['mobile_no']); ?>"
                                                        required maxlength="10"
                                                        onkeypress="return /[0-9]/.test(event.key);">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Gender</label>
                                                    <select name="gender" class="form-control" required>
                                                        <option value="male" <?php if ($user['gender'] === 'male') echo 'selected'; ?>>Male</option>
                                                        <option value="female" <?php if ($user['gender'] === 'female') echo 'selected'; ?>>Female</option>
                                                        <option value="other" <?php if ($user['gender'] === 'other') echo 'selected'; ?>>Other</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Address</label>
                                                    <textarea name="address" class="form-control" required><?php echo htmlentities($user['address']); ?></textarea>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>City</label>
                                                    <input type="text" name="city" class="form-control"
                                                        value="<?php echo htmlentities($user['city']); ?>" required
                                                        onkeypress="return /[a-zA-Z\s]/.test(event.key);">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Country</label>
                                                    <select name="country" class="form-control" required>
                                                        <?php
                                                        $countries = ["India", "United States", "United Kingdom", "Canada", "Australia", "Other"];
                                                        foreach ($countries as $c) {
                                                            $selected = ($user['country'] === $c) ? "selected" : "";
                                                            echo "<option value='" . htmlentities($c) . "' $selected>" . htmlentities($c) . "</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>State</label>
                                                    <select name="state" class="form-control" required>
                                                        <?php
                                                        $states = ["Andhra Pradesh","Arunachal Pradesh","Assam","Bihar","Chhattisgarh","Goa","Gujarat","Haryana","Himachal Pradesh","Jharkhand","Karnataka","Kerala","Madhya Pradesh","Maharashtra","Manipur","Meghalaya","Mizoram","Nagaland","Odisha","Punjab","Rajasthan","Sikkim","Tamil Nadu","Telangana","Tripura","Uttar Pradesh","Uttarakhand","West Bengal"];
                                                        foreach ($states as $s) {
                                                            $selected = ($user['state'] === $s) ? "selected" : "";
                                                            echo "<option value='" . htmlentities($s) . "' $selected>" . htmlentities($s) . "</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Pincode</label>
                                                    <input type="text" name="pincode" class="form-control"
                                                        value="<?php echo htmlentities($user['pincode']); ?>"
                                                        required maxlength="6"
                                                        onkeypress="return /[0-9]/.test(event.key);">
                                                </div>

                                                <div class="col-md-6 mb-3">
                                                    <label>Blood Group</label>
                                                    <select name="bloodgroup" class="form-control" required>
                                                        <option value="">-- Select --</option>
                                                        <?php
                                                        $groups = ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'];
                                                        foreach ($groups as $group) {
                                                            $sel = ($user['bloodgroup'] === $group) ? 'selected' : '';
                                                            echo "<option value='$group' $sel>$group</option>";
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="text-end">
                                                <button type="submit" name="submit" class="btn btn-primary">Update Profile</button>
                                            </div>
                                        </form>
                                    </div><!-- panel-body -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>
</body>
</html>
</script>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
<script src="assets/js/off-canvas.js"></script>
<script src="assets/js/hoverable-collapse.js"></script>
<script src="assets/js/misc.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
</body>
</html>