<?php
session_start();
include('include/config.php');

if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='userindex.php';</script>";
    exit();
}

$userId = $_SESSION['id'];

// Count data
$appCount = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(*) FROM appointment WHERE userId='$userId'"))[0];
$medCount = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(*) FROM appointment WHERE userId='$userId'"))[0];
$docAvail = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(DISTINCT doctorId) FROM appointment WHERE userId='$userId'"))[0];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Patient | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />

    <style>
        body {
            background: #f4f6f9;
            font-family: 'Lato', sans-serif;
        }

        .card-report {
            border-radius: 16px;
            color: #fff;
            padding: 25px;
            position: relative;
            overflow: hidden;
            cursor: pointer;
            transition: transform .2s;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            min-height: 160px;
        }

        .card-report:hover {
            transform: translateY(-6px);
        }

        .card-bg1 {
            background: linear-gradient(135deg, #94821cff, #c9ac2aff);
        }

        .card-bg2 {
            background: linear-gradient(135deg, rgb(73, 175, 97), rgb(78, 170, 142));
        }

        .card-bg3 {
            background: linear-gradient(135deg, #ffc107, #ff9800);
        }

        .card-icon {
            font-size: 3rem;
            position: absolute;
            top: 20px;
            right: 20px;
            opacity: 0.25;
        }

        .dashboard-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .dashboard-count {
            font-size: 1.8rem;
            font-weight: 700;
        }

        .btn-light,
        .btn-outline-primary {
            border-radius: 10px;
            font-weight: 500;
        }

        .card h5 {
            font-weight: 600;
        }
    </style>
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">

                    <!-- Page Title -->
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Patient | Reports</h1>
                            </div>
                        </div>
                    </section>

                    <!-- Dashboard Cards -->
                    <div class="row mt-4 g-4">
                        <!-- Appointments -->
                        <div class="col-md-4">
                            <div class="card-report card-bg1 text-white">
                                <i class="fa fa-calendar card-icon"></i>
                                <div class="dashboard-title">Appointments</div>
                                <div class="dashboard-count"><?= $appCount ?></div>
                                <a href="appointment-history.php" class="btn btn-light btn-sm mt-3">View Appointments</a>
                            </div>
                        </div>

                        <!-- Medical History -->
                        <div class="col-md-4">
                            <div class="card-report card-bg2 text-white">
                                <i class="fa fa-medkit card-icon"></i>
                                <div class="dashboard-title">Medical History</div>
                                <div class="dashboard-count"><?= $medCount ?></div>
                                <a href="view-patient.php" class="btn btn-light btn-sm mt-3">View Medical History</a>
                            </div>
                        </div>

                        <!-- Doctor Availability -->
                        <!-- <div class="col-md-4">
                            <div class="card-report card-bg3 text-white">
                                <i class="fa fa-user-md card-icon"></i>
                                <div class="dashboard-title">Doctor Availability</div>
                                <div class="dashboard-count"><?= $docAvail ?></div>
                                <a href="doctoravailabledate.php" class="btn btn-light btn-sm mt-3">View Doctors</a>
                            </div>
                        </div> -->
                    </div>

                    <!-- Charts -->
                    <!-- <div class="row mt-5">
                    <div class="col-lg-8">
                        <div class="card p-3 bg-white rounded-3 shadow-sm">
                            <h5 class="mb-3">Monthly Appointments</h5>
                            <canvas id="appointmentsChart" height="120"></canvas>
                        </div>
                    </div>
                    <div class="col-lg-4 mt-3 mt-lg-0">
                        <div class="card p-3 bg-white rounded-3 shadow-sm">
                            <h5 class="mb-3">Health Status</h5>
                            <canvas id="patientStatusChart" height="200"></canvas>
                        </div>
                    </div>
                </div> -->

                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        // Appointments Chart
        new Chart(document.getElementById('appointmentsChart').getContext('2d'), {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                datasets: [{
                    label: 'Appointments',
                    data: [12, 19, 9, 15, 22, 18, 25, 28, 30, 20, 18, 24], // dummy data
                    borderColor: '#1e90ff',
                    backgroundColor: 'rgba(30,144,255,0.1)',
                    fill: true,
                    tension: 0.4
                }]
            }
        });

        // Patient Status Chart
        new Chart(document.getElementById('patientStatusChart').getContext('2d'), {
            type: 'doughnut',
            data: {
                labels: ['Active', 'Recovered', 'Under Treatment'],
                datasets: [{
                    data: [55, 30, 15], // dummy data
                    backgroundColor: ['#28a745', '#ffc107', '#dc3545']
                }]
            }
        });
    </script>
    <script>
        $(document).ready(function() {
            $(".main-navigation-menu li > a").click(function(e) {
                var parentLi = $(this).parent("li");

                // If this menu has a submenu
                if (parentLi.find(".sub-menu").length > 0) {
                    e.preventDefault(); // Prevent going to link

                    // Toggle submenu
                    parentLi.toggleClass("open");
                    parentLi.find(".sub-menu").slideToggle(200);

                    // Close other open menus (optional)
                    parentLi.siblings().removeClass("open").find(".sub-menu").slideUp(200);
                }
            });
        });
    </script>

</body>

</html>