<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    echo "<script>alert('User not logged in!'); window.location.href='userindex.php';</script>";
    exit();
}

$userid = $_SESSION['id'];  // Logged-in patient ID

if (isset($_POST['submit'])) {
    $specilization = $_POST['Doctorspecialization'];
    $doctorid      = $_POST['doctor'];
    $fees          = $_POST['fees'];
    $reason        = $_POST['reason'];

    // Convert date (from dd/mm/yyyy to Y-m-d)
    $appdate = DateTime::createFromFormat('d/m/Y', $_POST['appointmentDate'])->format('Y-m-d');

    // Convert time (from 2:35 AM/PM to H:i:s)
    $timeInput     = $_POST['start_time'];
    $timeFormatted = date("H:i:s", strtotime($timeInput));

    // Adjust day_id: Monday=0 ... Sunday=6
    $day_id = date('w', strtotime($appdate)); // Sunday = 0
    $day_id = $day_id == 0 ? 6 : $day_id - 1;

    // Check if doctor is available
    $avail_sql = "SELECT start_time, end_time 
                  FROM doctor_shift_master 
                  WHERE doc_id=? AND day_id=? 
                    AND start_time <= ? AND end_time >= ?";
    $stmt = $con->prepare($avail_sql);
    $stmt->bind_param("iiss", $doctorid, $day_id, $timeFormatted, $timeFormatted);
    $stmt->execute();
    $result = $stmt->get_result();

    $userstatus = 1;
    $docstatus  = 1;

    // ✅ Insert appointment with op_id (same as users.id)
    $query = $con->prepare("INSERT INTO appointment
        (doctorSpecialization, doctorId, userId, op_id, consultancyFees, appointmentDate, appointmentTime, reason, userStatus, doctorStatus)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $query->bind_param(
        "siiissssii",
        $specilization,
        $doctorid,
        $userid,
        $userid,        // ✅ op_id same as patient id
        $fees,
        $appdate,
        $timeFormatted,
        $reason,
        $userstatus,
        $docstatus
    );

    if ($query->execute()) {
        $appointment_id = $query->insert_id;
        echo "<script>alert('✅ Appointment successfully booked. Appointment ID: $appointment_id'); window.location.href='book-appointment.php';</script>";
        exit();
    } else {
        echo "<script>alert('❌ Error booking appointment. Please try again.'); window.history.back();</script>";
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Patient | Reports</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Patient | Book Appointment</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container-fluid container-fullw bg-white">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-white">
                                    <div class="panel-heading">
                                        <!-- <h5 class="panel-title">Book Appointment</h5> -->
                                    </div>
                                    <div class="panel-body">
                                        <form role="form" name="book" method="post">
                                            <div class="col-md-12">
                                                <label>Doctor Specialization</label>
                                                <select name="Doctorspecialization" class="form-control"
                                                    onChange="getdoctor(this.value);" required>
                                                    <option value="">Select Specialization</option>
                                                    <?php
                                                    $ret = mysqli_query($con, "SELECT * FROM doctorspecilization");
                                                    while ($row = mysqli_fetch_array($ret)) {
                                                        echo "<option value='" . $row['specilization'] . "'>" . $row['specilization'] . "</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="col-md-12">
                                                <label>Doctors</label>
                                                <select name="doctor" class="form-control" id="doctor"
                                                    onChange="getfee(this.value);" required>
                                                    <option value="">Select Doctor</option>
                                                </select>
                                            </div>

                                            <div class="col-md-12">
                                                <label>Consultancy Fees</label>
                                                <select name="fees" class="form-control" id="fees" readonly></select>
                                            </div>

                                            <div class="col-md-12">
                                                <label>Appointment Date</label>
                                                <input type="text" class="form-control datepicker"
                                                    name="appointmentDate" required placeholder="dd/mm/yyyy">
                                            </div>

                                            <div class="col-md-12">
                                                <label class="form-label">Start Time</label>
                                                <input type="time" name="start_time" class="form-control" required>
                                            </div>

                                            <div class="col-md-12">
                                                <label class="form-label">Reason for Appointment</label>
                                                <textarea name="reason" class="form-control"
                                                    placeholder="Enter reason for appointment" required></textarea>
                                            </div>

                                            <div class="col-md-12 mt-3">
                                                <button type="submit" name="submit" class="btn btn-primary">
                                                    Book Appointment
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
    <script>
        // Datepicker - allow only today and future dates
        $('.datepicker').datepicker({
            format: 'dd/mm/yyyy',
            startDate: new Date(),
            autoclose: true
        });

        function getdoctor(val) {
            $.ajax({
                type: "POST",
                url: "get_doctor.php",
                data: 'specilizationid=' + val,
                success: function(data) {
                    $("#doctor").html(data);
                }
            });
        }

        function getfee(val) {
            $.ajax({
                type: "POST",
                url: "get_doctor.php",
                data: 'doctor=' + val,
                success: function(data) {
                    $("#fees").html(data);
                }
            });
        }
    </script>
    <script>
        // Datepicker - allow only today and future dates
        $('.datepicker').datepicker({
            format: 'dd/mm/yyyy',
            startDate: new Date(),
            autoclose: true
        });

        function getdoctor(val) {
            $.ajax({
                type: "POST",
                url: "get_doctor.php",
                data: 'specilizationid=' + val,
                success: function(data) {
                    $("#doctor").html(data);
                }
            });
        }

        function getfee(val) {
            $.ajax({
                type: "POST",
                url: "get_doctor.php",
                data: 'doctor=' + val,
                success: function(data) {
                    $("#fees").html(data);
                }
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            $(".main-navigation-menu li > a").click(function(e) {
                var parentLi = $(this).parent("li");

                // If this menu has a submenu
                if (parentLi.find(".sub-menu").length > 0) {
                    e.preventDefault(); // Prevent going to link

                    // Toggle submenu
                    parentLi.toggleClass("open");
                    parentLi.find(".sub-menu").slideToggle(200);

                    // Close other open menus (optional)
                    parentLi.siblings().removeClass("open").find(".sub-menu").slideUp(200);
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#example1').DataTable();
        });
    </script>
    <script src="assets/js/main.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
        });
    </script>
</body>

</html>