    <?php
    include "include/config.php"; // mysqli $con ready

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        try {
            // --- Handle multi-select medical conditions ---
            $medical_conditions = isset($_POST['medical_conditions']) ? implode(',', $_POST['medical_conditions']) : null;

            // --- Handle document uploads ---
            $uploaded_files = [];
            if (!empty($_FILES['documents']['name'][0])) {
                // ensure uploads folder exists
                if (!is_dir("uploads")) mkdir("uploads", 0777, true);

                foreach ($_FILES['documents']['name'] as $i => $name) {
                    if ($_FILES['documents']['error'][$i] === UPLOAD_ERR_OK) {
                        $tmp = $_FILES['documents']['tmp_name'][$i];
                        $ext = pathinfo($name, PATHINFO_EXTENSION);
                        $newName = uniqid() . "." . $ext;
                        move_uploaded_file($tmp, "uploads/" . $newName);
                        $uploaded_files[] = $newName;
                    }
                }
            }
            $documents = $uploaded_files ? implode(',', $uploaded_files) : null;
            $password = $_POST['password'] ?? null;
            if ($password) {
                $password_hash = password_hash($password, PASSWORD_DEFAULT);
            } else {
                $password_hash = null;
            }

            // --- Consent ---
            $consent = isset($_POST['consent']) ? 1 : 0;

            // --- Assign POST values to variables ---
            $title = $_POST['title'] ?? null;
            $first_name = $_POST['first_name'] ?? null;
            $last_name = $_POST['last_name'] ?? null;
            $dob = $_POST['dob'] ?? null;
            $age = $_POST['age'] ?? null;
            $gender = $_POST['gender'] ?? null;
            $mobile = $_POST['mobile'] ?? null;
            $alternate_mobile = $_POST['alternate_mobile'] ?? null;
            $email = $_POST['email'] ?? null;
            $address_line1 = $_POST['address_line1'] ?? null;
            $address_line2 = $_POST['address_line2'] ?? null;
            $city = $_POST['city'] ?? null;
            $state = $_POST['state'] ?? null;
            $pincode = $_POST['pincode'] ?? null;
            $id_type = $_POST['id_type'] ?? null;
            $id_number = $_POST['id_number'] ?? null;
            $emergency_name = $_POST['emergency_name'] ?? null;
            $emergency_relation = $_POST['emergency_relation'] ?? null;
            $emergency_phone = $_POST['emergency_phone'] ?? null;
            $occupation = $_POST['occupation'] ?? null;
            $blood_group = $_POST['blood_group'] ?? null;
            $allergies = $_POST['allergies'] ?? null;
            $insurance_provider = $_POST['insurance_provider'] ?? null;
            $policy_number = $_POST['policy_number'] ?? null;
            $policy_validity = $_POST['policy_validity'] ?? null;
            $preferred_doctor = $_POST['preferred_doctor'] ?? null;

            // --- Prepare SQL ---
            $stmt = $con->prepare("INSERT INTO registrations 
                (title, first_name, last_name, dob, age, gender, mobile, alternate_mobile, email, password, 
                address_line1, address_line2, city, state, pincode, id_type, id_number, emergency_name, 
                emergency_relation, emergency_phone, occupation, blood_group, allergies, medical_conditions, 
                insurance_provider, policy_number, policy_validity, preferred_doctor, consent, documents) 
                VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

            $stmt->bind_param(
                "ssssissssssssssssssssssssssssi",
                $title,
                $first_name,
                $last_name,
                $dob,
                $age,
                $gender,
                $mobile,
                $alternate_mobile,
                $email,
                $password_hash,
                $address_line1,
                $address_line2,
                $city,
                $state,
                $pincode,
                $id_type,
                $id_number,
                $emergency_name,
                $emergency_relation,
                $emergency_phone,
                $occupation,
                $blood_group,
                $allergies,
                $medical_conditions,
                $insurance_provider,
                $policy_number,
                $policy_validity,
                $preferred_doctor,
                $consent,
                $documents
            );

            if ($stmt->execute()) {
                // Registration success
                $reg_id = $stmt->insert_id; // auto id from registrations

                // --- Prepare values for users table ---
                $fullname = trim($first_name . " " . $last_name);
                $username = $first_name;
                $created_at = date("Y-m-d H:i:s");
                $status = 0;

                $stmtUser = $con->prepare("INSERT INTO users 
            (fullName, address, city, gender, username, password, email, dob, mobile_no, regDate, age, bloodgroup, pincode, status) 
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

                $stmtUser->bind_param(
                    "ssssssssssissi",
                    $fullname,            // fullName = first + last
                    $address_line1,       // address
                    $city,                // city
                    $gender,              // gender
                    $username,            // username = firstname
                    $password_hash,       // password hash
                    $email,               // email
                    $dob,                 // dob
                    $mobile,              // mobile_no
                    $created_at,          // regDate
                    $age,                 // age
                    $blood_group,         // bloodgroup
                    $pincode,             // pincode
                    $status               // status default 0
                );

                if ($stmtUser->execute()) {
                    echo "<script>alert('Registration successful!');window.location='userindex.php';</script>";
                } else {
                    echo "<script>alert('Users table error: " . $stmtUser->error . "');</script>";
                }
                $stmtUser->close();
            } else {
                echo "<script>alert('DB Error: " . $stmt->error . "');</script>";
            }



            $stmt->close();
        } catch (Exception $e) {
            echo "<script>alert('Error: " . $e->getMessage() . "');</script>";
        }
    }
    ?>



    <!doctype html>
    <html lang="en">

    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <title>Patient Registration Form</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <script>
            function calcAge() {
                const dob = document.getElementById('dob').value;
                if (!dob) return;
                const birth = new Date(dob);
                const today = new Date();
                let age = today.getFullYear() - birth.getFullYear();
                const m = today.getMonth() - birth.getMonth();
                if (m < 0 || (m === 0 && today.getDate() < birth.getDate())) age--;
                document.getElementById('age').value = age;
            }

            function toggleAgeOverride(cb) {
                document.getElementById('age').readOnly = !cb.checked;
            }

            function validateMobilePattern(mobile) {
                return /^[6-9]\d{9}$/.test(mobile);
            }

            function onSubmit(ev) {
                const mobile = document.getElementById('mobile').value.trim();
                const first = document.getElementById('first_name').value.trim();
                const dob = document.getElementById('dob').value.trim();
                const consent = document.getElementById('consent').checked;
                let errors = [];
                if (!first) errors.push('First name required');
                if (!dob) errors.push('DOB required');
                if (!mobile) errors.push('Mobile required');
                if (!consent) errors.push('Consent required');
                if (mobile && !validateMobilePattern(mobile)) errors.push('Mobile must start 6-9 and 10 digits');
                if (errors.length) {
                    ev.preventDefault();
                    alert(errors.join('\n'));
                }
            }

            function allowOnlyNumbers(id) {
                document.getElementById(id).addEventListener("input", function() {
                    this.value = this.value.replace(/[^0-9]/g, '');
                });
            }
            window.onload = function() {
                allowOnlyNumbers("mobile");
                allowOnlyNumbers("alternate_mobile");
            }

            function onSubmit(ev) {
                const mobile = document.getElementById('mobile').value.trim();
                const first = document.getElementById('first_name').value.trim();
                const dob = document.getElementById('dob').value.trim();
                const consent = document.getElementById('consent').checked;
                const password = document.getElementById('password').value;
                const confirm = document.getElementById('confirm_password').value;

                let errors = [];
                if (!first) errors.push('First name required');
                if (!dob) errors.push('DOB required');
                if (!mobile) errors.push('Mobile required');
                if (!consent) errors.push('Consent required');
                if (!password) errors.push('Password required');
                if (password !== confirm) errors.push('Passwords do not match');
                if (mobile && !/^[6-9]\d{9}$/.test(mobile)) errors.push('Mobile must start 6-9 and 10 digits');

                if (errors.length) {
                    ev.preventDefault();
                    alert(errors.join('\n'));
                }
            }
        </script>
    </head>

    <body class="bg-light">
        <div class="container py-4">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white">
                    <h3 class="mb-0">Patient Registration Form</h3>
                </div>
                <div class="card-body">
                    <form method="post" enctype="multipart/form-data" onsubmit="onSubmit(event)">

                        <div class="row mb-3">
                            <div class="col-md-2">
                                <label class="form-label">Title</label>
                                <select name="title" class="form-select">
                                    <option value="">--</option>
                                    <option>Mr</option>
                                    <option>Ms</option>
                                    <option>Dr</option>
                                </select>
                            </div>
                            <div class="col-md-5">
                                <label class="form-label">First Name *</label>
                                <input id="first_name" name="first_name" type="text" class="form-control" required>
                            </div>
                            <div class="col-md-5">
                                <label class="form-label">Last Name</label>
                                <input name="last_name" type="text" class="form-control">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Date of Birth *</label>
                                <input id="dob" name="dob" type="date" class="form-control" onchange="calcAge()" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Age</label>
                                <input id="age" name="age" type="text" class="form-control" readonly>
                                <div class="form-check mt-1">
                                    <input type="checkbox" class="form-check-input" id="age_override" onclick="toggleAgeOverride(this)">
                                    <label class="form-check-label" for="age_override">Manual override</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Gender *</label>
                                <select name="gender" class="form-select" required>
                                    <option value="">--Select--</option>
                                    <option>Male</option>
                                    <option>Female</option>
                                    <option>Other</option>
                                </select>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Mobile Number *</label>
                                <input id="mobile" name="mobile" type="text" maxlength="10" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Alternate Mobile</label>
                                <input id="alternate_mobile" name="alternate_mobile" type="text" maxlength="10" class="form-control">
                            </div>
                        </div>




                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <input name="email" type="email" class="form-control">
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Password *</label>
                                <input id="password" name="password" type="password" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Confirm Password *</label>
                                <input id="confirm_password" name="confirm_password" type="password" class="form-control" required>
                            </div>
                        </div>

                        <h5 class="mt-4">Address</h5>
                        <div class="mb-2">
                            <input name="address_line1" type="text" placeholder="Address Line 1" class="form-control">
                        </div>
                        <div class="mb-2">
                            <input name="address_line2" type="text" placeholder="Address Line 2" class="form-control">
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-4"><input name="city" type="text" placeholder="City" class="form-control"></div>
                            <div class="col-md-4"><input name="state" type="text" placeholder="State" class="form-control"></div>
                            <div class="col-md-4"><input name="pincode" type="text" placeholder="Pincode" class="form-control"></div>
                        </div>

                        <h5>ID Proof</h5>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <select name="id_type" class="form-select">
                                    <option value="">--Select ID Type--</option>
                                    <option>Aadhar</option>
                                    <option>Passport</option>
                                    <option>Driving License</option>
                                </select>
                            </div>
                            <div class="col-md-6"><input name="id_number" type="text" placeholder="ID Number" class="form-control"></div>
                        </div>

                        <h5>Emergency Contact</h5>
                        <div class="row mb-3">
                            <div class="col-md-4"><input name="emergency_name" type="text" placeholder="Name" class="form-control"></div>
                            <div class="col-md-4"><input name="emergency_relation" type="text" placeholder="Relation" class="form-control"></div>
                            <div class="col-md-4"><input name="emergency_phone" type="text" placeholder="Phone" class="form-control"></div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Occupation</label>
                            <input name="occupation" type="text" class="form-control">
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Blood Group</label>
                                <select name="blood_group" class="form-select">
                                    <option value="">--</option>
                                    <option>A+</option>
                                    <option>A-</option>
                                    <option>B+</option>
                                    <option>B-</option>
                                    <option>O+</option>
                                    <option>O-</option>
                                    <option>AB+</option>
                                    <option>AB-</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Allergies</label>
                                <textarea name="allergies" class="form-control"></textarea>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Known Medical Conditions</label>
                            <select name="medical_conditions[]" multiple class="form-select">
                                <option>Diabetes</option>
                                <option>Hypertension</option>
                                <option>Asthma</option>
                                <option>Heart Disease</option>
                                <option>None</option>
                            </select>
                        </div>

                        <h5>Insurance</h5>
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <select name="insurance_provider" class="form-select">
                                    <option value="">--Select Provider--</option>
                                    <option>Provider A</option>
                                    <option>Provider B</option>
                                </select>
                            </div>
                            <div class="col-md-4"><input name="policy_number" type="text" placeholder="Policy Number" class="form-control"></div>
                            <div class="col-md-4"><input name="policy_validity" type="date" class="form-control"></div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Preferred Doctor</label>
                            <select name="preferred_doctor" class="form-select">
                                <option value="">--</option>
                                <option>Dr. A</option>
                                <option>Dr. B</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Upload Documents (image/pdf, max 2MB each)</label>
                            <input name="documents[]" type="file" multiple class="form-control" accept="image/*,application/pdf">
                        </div>

                        <div class="form-check mb-3">
                            <input id="consent" name="consent" type="checkbox" value="1" class="form-check-input" required>
                            <label for="consent" class="form-check-label">I consent to data processing (privacy policy) *</label>
                        </div>

                        <button type="submit" class="btn btn-primary">Submit Registration</button>
                        <div class="login-link">
                            Already have an account? <a href="userindex.php">Login</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    </body>

    </html>