<?php
include('include/config.php');

if (isset($_POST['doctor_id'])) {
    $doctor_id = intval($_POST['doctor_id']);
    $days = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];

    $query = $con->prepare("
        SELECT day_id, shift_type, start_time, end_time 
        FROM doctor_shift_master 
        WHERE doc_id = ? 
        ORDER BY day_id, FIELD(shift_type,'Morning','Afternoon','Evening','Night')
    ");
    $query->bind_param("i", $doctor_id);
    $query->execute();
    $result = $query->get_result();

    if ($result->num_rows > 0) {
        echo "<table class='table table-bordered'>";
        echo "<thead><tr>
                <th>Day</th>
                <th>Shift</th>
                <th>Start Time</th>
                <th>End Time</th>
              </tr></thead><tbody>";
        while ($row = $result->fetch_assoc()) {
            $dayName = isset($days[$row['day_id']]) ? $days[$row['day_id']] : "N/A";
            echo "<tr>
                    <td>{$dayName}</td>
                    <td>{$row['shift_type']}</td>
                    <td>{$row['start_time']}</td>
                    <td>{$row['end_time']}</td>
                 </tr>";
        }
        echo "</tbody></table>";
    } else {
        echo "<p>No availability found.</p>";
    }
}
?>
