<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
  header('location:userindex.php');
  exit();
}

$uid = $_SESSION['id'];

// =====================
// CANCEL APPOINTMENT
// =====================
if (isset($_GET['id'])) {
  $appointmentId = intval($_GET['id']);
  $query = mysqli_query($con, "UPDATE appointment 
                                 SET userStatus = 0 
                                 WHERE id = '$appointmentId' AND userId = '$uid'");
  $_SESSION['msg'] = $query ? "Appointment cancelled successfully!" : "Error cancelling appointment.";
  header("Location: appointment-history.php");
  exit();
}

// =====================
// COUNT TOTAL APPOINTMENTS
// =====================
$countQuery = mysqli_query($con, "
  SELECT COUNT(*) AS total 
  FROM appointment a
  WHERE a.userId = '$uid'
");
$countRow = mysqli_fetch_assoc($countQuery);
$totalAppointments = $countRow['total'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Patient | Appointment History</title>
  <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
  <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
  <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="shortcut icon" href="assets/images/favicon.png" />
  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
  <style>
    .detail_modal {
      width: 50%;
    }

    #detailsModal th {
      width: 30%;
      background-color: #f8f9fa;
    }
  </style>
</head>

<body>
  <div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
      <?php include('include/header.php'); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          
          <div class="card shadow mt-4">
            <div class="card-header bg-primary text-white">
              <h3 class="mb-0">Appointment History</h3>
            </div>
            <div class="card-body">
              <?php if (isset($_SESSION['msg'])) { ?>
                <div class="alert alert-info"><?= htmlentities($_SESSION['msg']);
                                              unset($_SESSION['msg']); ?></div>
              <?php } ?>

              <!-- Total Appointments -->

              <table id="appointmentTable" class="table table-hover">
                <thead class="thead-dark">
                  <tr>
                    <th>SNO</th>
                    <th>Doctor Name</th>
                    <th>Specialization</th>
                    <th>Fees</th>
                    <th>Date & Time</th>
                    <th>Reason</th>
                    <th>Status</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  $sql = mysqli_query($con, "
                  SELECT a.*, d.doctorName, d.specilization, d.docFees
                  FROM appointment a
                  JOIN doctors d ON d.id = a.doctorId
                  WHERE a.userId='$uid'
                  ORDER BY a.appointmentDate DESC, a.appointmentTime ASC
                ");
                  $cnt = 1;
                  if (mysqli_num_rows($sql) == 0) {
                    echo "<tr><td colspan='8' class='text-center text-danger'>No appointments found.</td></tr>";
                  }
                  while ($row = mysqli_fetch_array($sql)) {
                    $timeAmPm = date("h:i A", strtotime($row['appointmentTime']));

                    // =====================
                    // STATUS LOGIC
                    // =====================
                    if ($row['userStatus'] == 1 && $row['doctorStatus'] == 1) {
                      $status = "<span class='badge badge-success'>Approved</span>";
                    } elseif ($row['userStatus'] == 1 && $row['doctorStatus'] == 2) {
                      $status = "<span class='badge badge-warning'>Pending</span>";
                    } elseif ($row['userStatus'] == 0 && $row['doctorStatus'] == 1) {
                      $status = "<span class='badge badge-danger'>Cancelled by You</span>";
                    } elseif ($row['userStatus'] == 1 && $row['doctorStatus'] == 0) {
                      $status = "<span class='badge badge-danger'>Cancelled by Doctor</span>";
                    } else {
                      $status = "<span class='badge badge-secondary'>Cancelled </span>";
                    }

                    echo "<tr>
                      <td>" . $cnt++ . "</td>
                      <td>" . htmlentities($row['doctorName']) . "</td>
                      <td>" . htmlentities($row['specilization']) . "</td>
                      <td>" . htmlentities($row['docFees']) . " rs</td>
                      <td>" . date('d/m/Y', strtotime($row['appointmentDate'])) . " $timeAmPm</td>
                      <td>" . htmlentities($row['reason']) . "</td>
                      <td>$status</td>
                      <td>
                        <button
                          class='btn btn-info btn-sm view-details'
                          data-toggle='modal'
                          data-target='#detailsModal'
                          data-doc='" . htmlentities($row['doctorName']) . "'
                          data-spec='" . htmlentities($row['specilization']) . "'
                          data-fees='" . htmlentities($row['docFees']) . "'
                          data-reason='" . htmlentities($row['reason']) . "'
                          data-date='" . date('d/m/Y', strtotime($row['appointmentDate'])) . "'
                          data-time='$timeAmPm'
                          data-status='" . htmlentities(strip_tags($status)) . "'
                        >View</button>
                        <a href='appointment-history.php?id=" . $row['id'] . "' 
                           class='btn btn-danger btn-sm'
                           onclick='return confirm(\"Cancel this appointment?\");'>Cancel</a>
                      </td>
                    </tr>";
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </div>

          <!-- Details Modal -->
          <div class="modal fade" id="detailsModal" tabindex="-1">
            <div class="modal-dialog modal-lg detail_modal">
              <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                  <h5 class="modal-title">Appointment Details</h5>
                  <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                  <table class="table table-bordered">
                    <tr>
                      <th>Doctor</th>
                      <td id="dDoc"></td>
                    </tr>
                    <tr>
                      <th>Specialization</th>
                      <td id="dSpec"></td>
                    </tr>
                    <tr>
                      <th>Fees</th>
                      <td id="dFees"></td>
                    </tr>
                    <tr>
                      <th>Reason</th>
                      <td id="dReason"></td>
                    </tr>
                    <tr>
                      <th>Date</th>
                      <td id="dDate"></td>
                    </tr>
                    <tr>
                      <th>Time</th>
                      <td id="dTime"></td>
                    </tr>
                    <tr>
                      <th>Status</th>
                      <td id="dStatus"></td>
                    </tr>
                  </table>
                </div>
                <div class="modal-footer">
                  <button class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <?php include('include/footer.php'); ?>

      </div>
    </div>
  </div>

  <script src="vendor/jquery/jquery.min.js"></script>
  <script>
    $(document).ready(function() {
      $('#appointmentTable').DataTable();

      $(document).on("click", ".view-details", function() {
        $("#dDoc").text($(this).data("doc"));
        $("#dSpec").text($(this).data("spec"));
        $("#dFees").text($(this).data("fees") + " rs");
        $("#dReason").text($(this).data("reason"));
        $("#dDate").text($(this).data("date"));
        $("#dTime").text($(this).data("time"));
        $("#dStatus").text($(this).data("status"));
      });
    });
  </script>

  <script src="assets/vendors/js/vendor.bundle.base.js"></script>
  <script src="assets/js/off-canvas.js"></script>
  <script src="assets/js/hoverable-collapse.js"></script>
  <script src="assets/js/misc.js"></script>
  <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
</body>

</html>