<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/config.php');

$threshold = 20;
$lowStockQuery = "SELECT name, batch_no, stock_quantity, category 
                  FROM medicine 
                  WHERE stock_quantity < {$threshold} 
                    AND status = 'Available' 
                    AND expiry_date >= CURDATE()";

$lowStockResult = $con->query($lowStockQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
<title>  Add Medicine</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />
</head>
<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Pharmacy | Manage Medicines </h1>
                        </div>
                    </div>
                </section>
    <style>
        body { background: #f4f6f9; }
        .page-title { font-weight: 700; }
        .card-header i { margin-right: 8px; }
        .badge-stock { font-size: 0.9rem; padding: 6px 10px; }
    </style>
</head>
<body>

<div class="container mt-4">
    <!-- <h2 class="page-title mb-4"><i class="fa-solid fa-pills"></i> Manage Medicines</h2> -->

    <!-- Low Stock Section -->
    <?php if ($lowStockResult && $lowStockResult->num_rows > 0): ?>
        <div class="alert alert-warning shadow-sm d-flex align-items-center">
            <i class="fa-solid fa-triangle-exclamation me-2"></i>
            <strong><?= $lowStockResult->num_rows ?> medicine(s)</strong> are below the minimum stock threshold (<?= $threshold ?>)!
        </div>

        <div class="card mb-4" id="low-stock-table">
            <div class="card-header bg-danger text-white">
                <i class="fa-solid fa-box-open"></i> Low Stock Medicines
            </div><br>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>No</th>
                                <th>Medicine Name</th>
                                <th>Batch No</th>
                                <th>Current Stock</th>
                                <th>Category</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; while ($rowLow = $lowStockResult->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                                    <td><?= htmlspecialchars($rowLow['name']) ?></td>
                                    <td><?= htmlspecialchars($rowLow['batch_no']) ?></td>
                                    <td><span class="badge bg-danger badge-stock"><?= $rowLow['stock_quantity'] ?></span></td>
                                    <td><?= htmlspecialchars($rowLow['category']) ?></td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <button class="btn btn-primary mb-4" onclick="printLowStock()">
            <i class="fa fa-print me-1"></i> Print Low Stock List
        </button><br><br>
    <?php else: ?>
        <div class="alert alert-success shadow-sm">
            <i class="fa fa-check-circle me-2"></i> All medicines are above the minimum stock level (<?= $threshold ?>).
        </div>
    <?php endif; ?>

    <!-- All Medicines Table -->
    <div class="card">
        <div class="card-header bg-primary text-white">
            <i class="fa fa-pills me-2"></i> All Medicines
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="example1" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Medicine Name</th>
                            <th>Batch No</th>
                            <th>Expiry Date</th>
                            <th>Stock</th>
                            <th>Category</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sql = mysqli_query($con, "SELECT * FROM medicine WHERE status = 'Available'");
                        $cnt = 1;
                        while ($rowAll = mysqli_fetch_array($sql)):
                        ?>
                            <tr>
                                <td><?= $cnt++ ?></td>
                                <td><?= htmlspecialchars($rowAll['name']) ?></td>
                                <td><?= htmlspecialchars($rowAll['batch_no']) ?></td>
                                <td><?= htmlspecialchars($rowAll['expiry_date']) ?></td>
                                <td><?= htmlspecialchars($rowAll['stock_quantity']) ?></td>
                                <td><?= htmlspecialchars($rowAll['category']) ?></td>
                                <td>
                                    <span class="badge bg-success"><?= htmlspecialchars($rowAll['status']) ?></span>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#example1').DataTable();
    });

    function printLowStock() {
        var content = document.getElementById('low-stock-table').innerHTML;
        var printWindow = window.open('', '', 'width=800,height=600');
        printWindow.document.write(`
            <html>
                <head>
                    <title>Print Low Stock</title>
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
                </head>
                <body>
                    <h3>Low Stock Medicines</h3>
                    ${content}
                    <script> window.onload = function() { window.print(); } <\/script>
                </body>
            </html>
        `);
        printWindow.document.close();
    }
</script>
</body>
</html>
 <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
</body>
</html>