<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/config.php');
include('include/checklogin.php');

$did = intval($_GET['id']);
$msg = "";

// Handle update submission
if (isset($_POST['submit'])) {
    $name = $_POST['name'];
    $category = $_POST['category'];
    $rate = $_POST['rate'];
    $batch_no = $_POST['batch_no'];
    $stock_quantity = $_POST['stock_quantity'];
    $status = $_POST['status'];

    $query = "UPDATE medicine SET 
                name=?, 
                category=?, 
                rate=?, 
                batch_no=?, 
                stock_quantity=?, 
                status=? 
              WHERE id=?";
    $stmt = mysqli_prepare($con, $query);
    mysqli_stmt_bind_param($stmt, 'ssssssi', $name, $category, $rate, $batch_no, $stock_quantity, $status, $did);

    if (mysqli_stmt_execute($stmt)) {
        $msg = "Medicine details updated successfully.";
    } else {
        $msg = "Failed to update medicine.";
    }

    mysqli_stmt_close($stmt);
}

// Fetch current medicine data
$sql = mysqli_query($con, "SELECT * FROM medicine WHERE id='$did'");
$data = mysqli_fetch_array($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Pharmacy | Edit Medicine Details</title>
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="vendor/fontawesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="vendor/themify-icons/themify-icons.min.css" rel="stylesheet">
    <link href="assets/css/styles.css" rel="stylesheet">
    <link href="assets/css/plugins.css" rel="stylesheet">
    <link href="assets/css/themes/theme-1.css" rel="stylesheet" id="skin_color">
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Pharmacy | Edit Medicine Details</h1>
                        </div>
                    </div>
                </section>

                <a href="manage-medi.php" class="btn btn-secondary mb-3">← Back to Manage Medicine</a>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if ($msg): ?>
                                <div class="alert alert-info mt-3"><?php echo htmlentities($msg); ?></div>
                            <?php endif; ?>

                            <div class="panel panel-white">
                                <div class="panel-heading">
                                    <h5 class="panel-title">Edit Medicine Info</h5>
                                </div>
                                <div class="panel-body">
                                    <h4><?php echo htmlentities($data['name']); ?>'s Profile</h4>
                                    <p><b>Profile Reg. Date:</b> <?php echo htmlentities($data['created']); ?></p>
                                    <hr />
                                    <form method="post">
                                        <div class="form-group">
                                            <label>Medicine Name:</label>
                                            <input type="text" name="name" class="form-control" value="<?php echo htmlentities($data['name']); ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Category:</label>
                                            <input type="text" name="category" class="form-control" value="<?php echo htmlentities($data['category']); ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Rate:</label>
                                            <input type="text" name="rate" class="form-control" value="<?php echo htmlentities($data['rate']); ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Batch No:</label>
                                            <input type="text" name="batch_no" class="form-control" value="<?php echo htmlentities($data['batch_no']); ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Stock Quantity:</label>
                                            <input type="number" name="stock_quantity" class="form-control" value="<?php echo htmlentities($data['stock_quantity']); ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Status:</label>
                                            <select name="status" class="form-control" required>
                                                <?php
                                                $statuses = ["Available", "Out of Stock", "Expired"];
                                                foreach ($statuses as $stat) {
                                                    $selected = ($data['status'] == $stat) ? 'selected' : '';
                                                    echo "<option value=\"$stat\" $selected>$stat</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <button type="submit" name="submit" class="btn btn-primary">Update Medicine</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
