<?php
ob_start();                         // prevent accidental output before header()
require 'include/config.php';
error_reporting(E_ALL);

/* ---- dropdown data ---- */
$patients = mysqli_query($con, "SELECT id, fullName FROM users ORDER BY id");

/* ---- save bill ---- */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pid      = intval($_POST['patient_id']);
    $pname    = $_POST['fullName'];          // comes from hidden field
    $type     = $_POST['bill_type'];
    $amount   = floatval($_POST['amount']);
    $discount = floatval($_POST['discount']);
    $total    = $amount - $discount;
    $method   = $_POST['payment_method'];
    $status   = $_POST['payment_status'];
    $date     = date('Y-m-d H:i:s');

    $sql  = "INSERT INTO pharm_billing
             (patient_id, fullName, bill_type, amount, discount, total_amount,
              payment_method, payment_status, payment_date)
             VALUES (?,?,?,?,?,?,?,?,?)";

    $stmt = $con->prepare($sql);
    $stmt->bind_param(
        'issdddsss',
        $pid, $pname, $type, $amount, $discount, $total,
        $method, $status, $date
    );

    if (!$stmt->execute()) {
        die("Insert error: " . $stmt->error);
    }

    $bill_id = $stmt->insert_id;
    header("Location: bill_print.php?id=" . $bill_id);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Pharmacy | Create Bill</title>

    <!-- ==== global CSS (same stack you already use) ==== -->
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic"
          rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css" />
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" />
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>

<body>
    <div id="app">
        <?php include 'include/sidebar.php'; ?>

        <div class="app-content">
            <?php include 'include/header.php'; ?>

            <!-- ======= MAIN CONTENT ======= -->
            <div class="main-content">
                <div class="wrap-content container" id="container">

                    <!-- page‑title -->
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Pharmacy | Create Bill</h1>
                            </div>
                        </div>
                    </section>

                    <!-- ====== BILL FORM ====== -->
                    <form method="POST" class="p-4 card" style="max-width: 700px">
                        <div class="mb-3">
                            <label class="form-label">Patient</label>
                            <select class="form-select" name="patient_id" id="patientSel" required>
                                <option value="">Select</option>
                                <?php while ($p = mysqli_fetch_assoc($patients)): ?>
                                    <option value="<?= $p['id'] ?>" data-name="<?= $p['fullName'] ?>">
                                        <?= htmlspecialchars($p['fullName']) ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                            <input type="hidden" name="fullName" id="pnameHidden">
                        </div>
<br>
                        <div class="mb-3">
                            <label class="form-label">Billing Type</label>
                            <select name="bill_type" class="form-select" required>
                                <option value="">Select</option>
                                <option>Pharmacy</option>
                                <option>Consultation</option>
                                <option>Lab</option>
                            </select>
                        </div>
<br>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Amount (₹)</label>
                                <input type="number" name="amount" step="0.01" class="form-control" required>
                            </div>
<br>
                            <div class="col-md-6">
                                <label class="form-label">Discount (₹)</label>
                                <input type="number" name="discount" step="0.01" value="0" class="form-control">
                            </div>
                        </div>
<br>
                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label class="form-label">Payment Method</label>
                                <select name="payment_method" class="form-select" required>
                                    <option>Cash</option>
                                    <option>Card</option>
                                    <option>UPI</option>
                                </select>
                            </div>
<br>
                            <div class="col-md-6">
                                <label class="form-label">Payment Status</label>
                                <select name="payment_status" class="form-select" required>
                                    <option>Paid</option>
                                    <option>Unpaid</option>
                                </select>
                            </div>
                        </div>

                        <button class="btn btn-success mt-4">
                            <i class="fa fa-check"></i> Generate Bill
                        </button>
                    </form>
                    <!-- ===== END FORM ===== -->

                </div> <!-- /container -->
            </div> <!-- /main-content -->

            <?php include 'include/footer.php'; ?>
        </div> <!-- /app-content -->

        <?php include 'include/setting.php'; ?>
    </div> <!-- /app -->

    <!-- ====== JS ====== -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script>
    // copy selected patient's name into hidden field
    $('#patientSel').on('change', function () {
        $('#pnameHidden').val($('option:selected', this).data('name') || '');
    });
    </script>
</body>
</html>
