<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date           = $_POST['date'];
    $patient_id     = $_POST['patient_id'];
    $gst            = $_POST['gst'];
    $discount       = $_POST['discount'];
    $final_net      = $_POST['final_net_amount'];
    $payment_method = $_POST['payment_method'];
    $created_by     = $_SESSION['id'] ?? 'system';

    // Items (arrays)
    $medicine_ids = $_POST['medicine_id'];
    $item_names   = $_POST['item_name'];
    $qtys         = $_POST['qty'];
    $rates        = $_POST['rate'];
    $totals       = $_POST['total'];

    // ✅ Generate invoice number
    $query = mysqli_query($con, "SELECT invoice_number FROM invoice ORDER BY id DESC LIMIT 1");
    $lastInvoice = mysqli_fetch_assoc($query);

    if ($lastInvoice && !empty($lastInvoice['invoice_number'])) {
        $lastNumber = (int) filter_var($lastInvoice['invoice_number'], FILTER_SANITIZE_NUMBER_INT);
        $newNumber = $lastNumber + 1;
    } else {
        $newNumber = 1;
    }
    $invoice_number = "INV" . date("Y") . str_pad($newNumber, 4, "0", STR_PAD_LEFT);

    // ✅ Insert into invoice table
    $stmt = $con->prepare("INSERT INTO invoice 
        (date, patient_id, invoice_number, gst, discount, final_net_amount, payment_method, created_by) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sisdddss", 
        $date, $patient_id, $invoice_number, $gst, $discount, $final_net, $payment_method, $created_by
    );
    $stmt->execute();
    $invoice_id = $stmt->insert_id;
    $stmt->close();

    // ✅ Insert items + update stock
    $stmt2 = $con->prepare("INSERT INTO addinvoice_items (invoice_id, medicine_id, item_name, qty, rate, total) VALUES (?, ?, ?, ?, ?, ?)");
    foreach ($medicine_ids as $i => $medId) {
        $iname = $item_names[$i];
        $q     = $qtys[$i];
        $r     = $rates[$i];
        $t     = $totals[$i];

        $stmt2->bind_param("iisidd", $invoice_id, $medId, $iname, $q, $r, $t);
        $stmt2->execute();

        // Reduce stock
        $con->query("UPDATE medicine SET stock = stock - $q WHERE id = $medId");
    }
    $stmt2->close();

    $msg = "✅ Invoice added successfully!";
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Invoice</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <style>
        table { width:100%; border-collapse: collapse; margin-bottom: 10px; }
        table, th, td { border: 1px solid black; padding: 6px; }
    </style>
</head>
<body>
<div class="container mt-4">
    <h2>Pharmacy | Add Invoice</h2>
    <p style="color:green;"><?= $msg ?></p>

    <form method="POST">

        <div class="form-group">
            <label>Date:</label>
            <input type="date" name="date" class="form-control" required>
        </div>

        <div class="form-group">
            <label>Patient Name:</label>
            <select name="patient_id" class="form-control" required>
                <option value="">Select Patient</option>
                <?php
                $ret = mysqli_query($con, "SELECT id, fullName FROM users ORDER BY fullName");
                while ($row = mysqli_fetch_assoc($ret)) {
                    echo '<option value="'.$row['id'].'">'.htmlentities($row['fullName']).'</option>';
                }
                ?>
            </select>
        </div>

        <h3>Invoice Items</h3>
        <table id="itemsTable">
            <tr>
                <th>Medicine</th>
                <th>Item Name</th>
                <th>Qty</th>
                <th>Rate</th>
                <th>Total</th>
                <th>Action</th>
            </tr>
            <tr>
                <td>
                    <select name="medicine_id[]" class="form-select" onchange="fetchMedicine(this)" required>
                        <option value="">Select Medicine</option>
                        <?php
                        $res = $con->query("SELECT id, name FROM medicine");
                        while ($row = $res->fetch_assoc()) {
                            echo "<option value='{$row['id']}'>{$row['name']}</option>";
                        }
                        ?>
                    </select>
                </td>
                <td><input type="text" name="item_name[]" required></td>
                <td><input type="number" name="qty[]" value="1" step="1" onchange="calculateRowTotal(this.closest('tr'))" required></td>
                <td><input type="number" name="rate[]" step="0.01" onchange="calculateRowTotal(this.closest('tr'))" required></td>
                <td><input type="number" name="total[]" step="0.01" readonly></td>
                <td><button type="button" onclick="this.parentNode.parentNode.remove()">❌</button></td>
            </tr>
        </table>
        <button type="button" onclick="addRow()">➕ Add Item</button><br><br>

        <div class="form-group">
            <label>GST (%):</label>
            <input type="number" name="gst" step="0.01" class="form-control" oninput="calculateFinalNet()">
        </div>

        <div class="form-group">
            <label>Discount:</label>
            <input type="number" name="discount" step="0.01" value="0.00" class="form-control" oninput="calculateFinalNet()">
        </div>

        <div class="form-group">
            <label>Final Net:</label>
            <input type="number" name="final_net_amount" step="0.01" class="form-control" readonly>
        </div>

        <div class="form-group">
            <label>Payment Method:</label>
            <select name="payment_method" class="form-control">
                <option>Cash</option>
                <option>Card</option>
                <option>UPI</option>
            </select>
        </div>

        <button type="submit" class="btn btn-success">Save Invoice</button>
    </form>
</div>

<script>
function addRow() {
    let table = document.getElementById("itemsTable");
    let row = table.insertRow(-1);
    row.innerHTML = `
        <td>
            <select name="medicine_id[]" class="form-select" onchange="fetchMedicine(this)" required>
                <option value="">Select Medicine</option>
                <?php
                $res = $con->query("SELECT id, name FROM medicine");
                while ($row = $res->fetch_assoc()) {
                    echo "<option value='{$row['id']}'>{$row['name']}</option>";
                }
                ?>
            </select>
        </td>
        <td><input type="text" name="item_name[]" required></td>
        <td><input type="number" name="qty[]" value="1" step="1" onchange="calculateRowTotal(this.closest('tr'))" required></td>
        <td><input type="number" name="rate[]" step="0.01" onchange="calculateRowTotal(this.closest('tr'))" required></td>
        <td><input type="number" name="total[]" step="0.01" readonly></td>
        <td><button type="button" onclick="this.parentNode.parentNode.remove()">❌</button></td>
    `;
}

function fetchMedicine(selectEl) {
    let medId = selectEl.value;
    if (!medId) return;

    fetch("fetch_medicine.php?id=" + medId)
        .then(res => res.json())
        .then(data => {
            if (data.price) {
                let row = selectEl.closest("tr");
                row.querySelector("input[name='rate[]']").value = data.price;
                row.querySelector("input[name='item_name[]']").value = data.name;
                calculateRowTotal(row);
            }
        });
}

function calculateRowTotal(row) {
    let qty  = parseFloat(row.querySelector("input[name='qty[]']").value) || 0;
    let rate = parseFloat(row.querySelector("input[name='rate[]']").value) || 0;
    row.querySelector("input[name='total[]']").value = (qty * rate).toFixed(2);
    calculateFinalNet();
}

function calculateFinalNet() {
    let totals = document.querySelectorAll("input[name='total[]']");
    let gst = parseFloat(document.querySelector("input[name='gst']").value) || 0;
    let discount = parseFloat(document.querySelector("input[name='discount']").value) || 0;

    let sum = 0;
    totals.forEach(t => sum += parseFloat(t.value) || 0);

    let finalAmount = sum + (sum * gst / 100) - discount;
    document.querySelector("input[name='final_net_amount']").value = finalAmount.toFixed(2);
}
</script>
</body>
</html>
