<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ============================
// Generate Next Medicine Code
// ============================
$result = mysqli_query($con, "SELECT medicine_code FROM medicine_masters ORDER BY id DESC LIMIT 1");
if ($row = mysqli_fetch_assoc($result)) {
    $lastCode = $row['medicine_code'];
    $lastNumber = intval(substr($lastCode, 3));
    $nextNumber = $lastNumber + 1;
    $medicine_code = "MED" . str_pad($nextNumber, 4, "0", STR_PAD_LEFT);
} else {
    $medicine_code = "MED0001";
}

// ============================
// Handle Form Submission
// ============================
if (isset($_POST['submit'])) {
    $medicine_name         = mysqli_real_escape_string($con, $_POST['medicine_name']);
    $batch_number          = mysqli_real_escape_string($con, $_POST['batch_number']);
    $composition           = mysqli_real_escape_string($con, $_POST['composition']);
    $strength              = mysqli_real_escape_string($con, $_POST['strength']);
    $unit_type             = mysqli_real_escape_string($con, $_POST['unit_type']);
    $description           = mysqli_real_escape_string($con, $_POST['description']);
    $notes                 = mysqli_real_escape_string($con, $_POST['notes']);
    $prescription_required = isset($_POST['prescription_required']) ? $_POST['prescription_required'] : 'No';

    // ============================
    // Handle Image Upload
    // ============================
    $image_name = '';
    if (isset($_FILES['medicine_image']) && $_FILES['medicine_image']['error'] == 0) {
        $upload_dir = "uploads/medicines/";
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0755, true);
        $ext = pathinfo($_FILES['medicine_image']['name'], PATHINFO_EXTENSION);
        $image_name = $medicine_code . "." . $ext;
        $target_file = $upload_dir . $image_name;
        if (!move_uploaded_file($_FILES['medicine_image']['tmp_name'], $target_file)) {
            $image_name = '';
        }
    }

    // ============================
    // Insert into Database
    // ============================
    $query = "INSERT INTO medicine_masters 
        (medicine_code, medicine_name, batch_number, composition, strength, unit_type, description, notes, image, prescription_required) 
        VALUES 
        ('$medicine_code','$medicine_name','$batch_number','$composition','$strength','$unit_type','$description','$notes','$image_name','$prescription_required')";

    if (mysqli_query($con, $query)) {
        echo "<script>alert('Medicine added successfully. Code: $medicine_code'); 
        window.location.href='manage-medicine.php';</script>";
    } else {
        echo "<script>alert('Error: Unable to add medicine - " . mysqli_error($con) . "');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
<title>  Add Medicine</title>
<link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
<link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
<link rel="stylesheet" href="assets/css/style.css" />
<link rel="shortcut icon" href="assets/images/favicon.png" />
</head>
<style>
    .form-check .form-check-label {
    display: block;
    margin-left: 1.75rem;
    font-size: 0.875rem;
    line-height: 1.5;
}
 .form-check-inline .form-check-input {
    position: static;
    margin-top: 4px;
    margin-right: 0.3125rem;
    margin-left: 28px;
}
</style>

<body>
<div class="container-scroller">
    <?php include('include/sidebar.php'); ?>
    <div class="container-fluid page-body-wrapper">
        <?php include('include/header.php'); ?>
        <div class="main-panel">
            <div class="content-wrapper">

                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle"> Add Medicine</h1>
                        </div>
                    </div>
                </section>

                <div class="container bg-white p-4 rounded shadow-sm">
                    <form method="post" enctype="multipart/form-data">
                        <div class="row">
                            <!-- Medicine Code -->
                            <div class="col-md-4 mb-3">
                                <label>Medicine Code</label>
                                <input type="text" name="medicine_code" class="form-control" value="<?= $medicine_code ?>" readonly>
                            </div>

                            <!-- Medicine Name / Category -->
                            <div class="col-md-4 mb-3">
                                <label>Category</label>
                                <select name="medicine_name" class="form-control" required>
                                    <option value="">-- Select Medicine --</option>
                                    <?php
                                    $medicine_result = mysqli_query($con, "SELECT DISTINCT name FROM medicine WHERE name IS NOT NULL AND name != ''");
                                    while ($row = mysqli_fetch_assoc($medicine_result)) {
                                        echo '<option value="' . htmlspecialchars($row['name']) . '">' . htmlspecialchars($row['name']) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>

                            <!-- Batch Number -->
                            <div class="col-md-4 mb-3">
                                <label>Batch Number</label>
                                <input type="text" name="batch_number" class="form-control">
                            </div>

                            <!-- Composition -->
                            <div class="col-md-4 mb-3">
                                <label>Composition / Formula</label>
                                <input type="text" name="composition" class="form-control" placeholder="e.g., Paracetamol 500mg">
                            </div>

                            <!-- Strength / Dosage Form -->
                            <div class="col-md-4 mb-3">
                                <label>Strength / Dosage Form</label>
                                <input type="text" name="strength" class="form-control" placeholder="e.g., 500 mg, 250 ml bottle">
                            </div>

                            <!-- Unit Type -->
                            <div class="col-md-4 mb-3">
                                <label>Unit Type</label>
                                <select name="unit_type" class="form-control" required>
                                    <option value="" disabled selected>-- Select Unit Type --</option>
                                    <option value="mg">mg (milligram)</option>
                                    <option value="g">g (gram)</option>
                                    <option value="ml">ml (milliliter)</option>
                                    <option value="IU">IU (International Unit)</option>
                                </select>
                            </div>

                            <!-- Description -->
                            <div class="col-md-8 mb-4">
                                <label>Description / Usage</label>
                                <textarea name="description" class="form-control"></textarea>
                            </div>

                            <!-- Notes -->
                            <div class="col-md-4 mb-3">
                                <label>Notes</label>
                                <textarea name="notes" class="form-control"></textarea>
                            </div>

                            <!-- Prescription Required -->
                            <div class="col-md-4 mb-3">
                                <label>Prescription Required</label><br>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="prescription_required" id="prescription_yes" value="Yes" required>
                                    <label class="form-check-label" for="prescription_yes">Yes</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="prescription_required" id="prescription_no" value="No">
                                    <label class="form-check-label" for="prescription_no">No</label>
                                </div>
                            </div>

                            <!-- Medicine Image -->
                            <div class="col-md-4 mb-3">
                                <label>Medicine Image</label>
                                <input type="file" name="medicine_image" class="form-control" accept="image/*">
                            </div>

                        </div>

                        <div class="text-end">
                            <button type="submit" name="submit" class="btn btn-primary">Save Medicine</button>
                        </div>
                    </form>
                </div>
            </div>
            <?php include('include/footer.php'); ?>
        </div>
    </div>
</div>

<script src="assets/vendors/js/vendor.bundle.base.js"></script>
</body>
</html>
