<?php
include('include/config.php');
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$query = mysqli_query($con, "SELECT * FROM ipd_requests WHERE id = $id AND status = 'admit'");
$data = mysqli_fetch_assoc($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Nurse | Nursing Schedule Activity</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet">
    <link href="vendor/select2/select2.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
    <div id="app">
        <?php include('include/sidebar.php'); ?>
        <div class="app-content">
            <?php include('include/header.php'); ?>

            <div class="main-content">
                <div class="wrap-content container" id="container">

                    <!-- Page Title -->
                    <section id="page-title" class="mt-3 mb-3">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h1 class="mainTitle text-primary">Nursing Schedule Activity</h1>
                                <span class="text-muted">Daily Patient Rounds Entry</span>
                            </div>
                        </div>
                    </section>

                    <!-- View IPD Request Details -->
                    <div class="container mt-4">
                        <h3 class="text-center">View IPD Request</h3>
                        <?php if ($data): ?>
                            <table class="table table-bordered">
                                <tr><th>Patient ID</th><td><?= htmlentities($data['patient_id']) ?></td></tr>
                                <tr><th>Patient Name</th><td><?= htmlentities($data['patient_name']) ?></td></tr>
                                <tr><th>Department</th><td><?= htmlentities($data['department']) ?></td></tr>
                                <tr><th>Reason for Admission</th><td><?= htmlentities($data['reason_for_admission']) ?></td></tr>
                                <tr><th>Recommended By</th><td><?= htmlentities($data['recommended_by']) ?></td></tr>
                                <tr><th>Request Date</th><td><?= htmlentities($data['request_date']) ?></td></tr>
                                <tr><th>Status</th><td><?= htmlentities($data['status']) ?></td></tr>
                            </table>
                            <a href="edit-ipd-request.php?id=<?= $data['id'] ?>" class="btn btn-warning">Edit</a>
                            <a href="delete-ipd-request.php?id=<?= $data['id'] ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this request?');">Delete</a>
                        <?php else: ?>
                            <div class="alert alert-danger">No record found!</div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
            <?php include('include/footer.php'); ?>
        </div>
        <?php include('include/setting.php'); ?>
    </div>

    <!-- Scripts -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendor/modernizr/modernizr.js"></script>
    <script src="vendor/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="vendor/switchery/switchery.min.js"></script>
    <script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
    <script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
    <script src="vendor/autosize/autosize.min.js"></script>
    <script src="vendor/selectFx/classie.js"></script>
    <script src="vendor/selectFx/selectFx.js"></script>
    <script src="vendor/select2/select2.min.js"></script>
    <script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/form-elements.js"></script>
    <script>
        jQuery(document).ready(function () {
            Main.init();
            FormElements.init();
        });
    </script>
</body>
</html>
