<?php
session_start();
error_reporting(0);
include('include/config.php');

// Validate ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['msg'] = "Invalid discharge summary ID.";
    header("Location: view_discharge_summary.php");
    exit;
}

$id = intval($_GET['id']);

// Fetch discharge summary
$stmt = mysqli_prepare($con, "SELECT * FROM discharge_summaries WHERE id = ?");
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$rowData = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt);

// If no record found
if (!$rowData) {
    $_SESSION['msg'] = "No discharge summary found for ID $id.";
    header("Location: view_discharge_summary.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Patient | Discharge Summary Details</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>

<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Patient | Discharge Summary Details</h1>
                        </div>
                        <ol class="breadcrumb">
                            <li><span>Patient</span></li>
                            <li class="active"><span>Discharge Summary</span></li>
                        </ol>
                    </div>
                </section>

                <!-- MESSAGE -->
                <?php
                if (isset($_SESSION['msg'])) {
                    echo '<div class="alert alert-info">'.htmlentities($_SESSION['msg']).'</div>';
                    unset($_SESSION['msg']);
                }
                ?>

                <!-- CONTENT -->
                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-bordered table-striped">
                                <tr>
                                    <th>Patient Name</th>
                                    <td><?php echo htmlentities($rowData['fullName']); ?></td>
                                </tr>
                                <tr>
                                    <th>Doctor Name</th>
                                    <td><?php echo htmlentities($rowData['doctorName']); ?></td>
                                </tr>
                                <tr>
                                    <th>Discharge Date</th>
                                    <td><?php echo htmlentities($rowData['discharge_date']); ?></td>
                                </tr>
                                <tr>
                                    <th>Diagnosis</th>
                                    <td><?php echo htmlentities($rowData['diagnosis']); ?></td>
                                </tr>
                                <tr>
                                    <th>Treatment Given</th>
                                    <td><?php echo htmlentities($rowData['treatment_given']); ?></td>
                                </tr>
                                <!-- <tr>
                                    <th>Follow Up</th>
                                    <td><?php echo htmlentities($rowData['follow_up']); ?></td>
                                </tr>
                                <tr>
                                    <th>Discharged By</th>
                                    <td><?php echo htmlentities($rowData['discharged_by']); ?></td>
                                </tr> -->
                            </table>
                            <a href="view_discharge_summary.php" class="btn btn-secondary">← Back</a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
