<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
  header('location:logout.php');
  exit();
}

// Handle delete request
if (isset($_GET['delid'])) {
  $delid = intval($_GET['delid']);

  // Delete related items first
  $stmt_items = mysqli_prepare($con, "DELETE FROM prescription_items WHERE prescription_id = ?");
  mysqli_stmt_bind_param($stmt_items, 'i', $delid);
  mysqli_stmt_execute($stmt_items);
  mysqli_stmt_close($stmt_items);

  // Delete prescription itself
  $stmt_prescription = mysqli_prepare($con, "DELETE FROM prescriptions WHERE id = ?");
  mysqli_stmt_bind_param($stmt_prescription, 'i', $delid);
  if (mysqli_stmt_execute($stmt_prescription)) {
    $_SESSION['msg'] = "Prescription deleted successfully.";
  } else {
    $_SESSION['msg'] = "Error deleting prescription.";
  }
  mysqli_stmt_close($stmt_prescription);

  header("Location: view-prescription.php");
  exit;
}

// Date filter
$from_date = $to_date = "";
$filterQuery = "";
if (!empty($_POST['from_date']) && !empty($_POST['to_date'])) {
  $from_date = $_POST['from_date'];
  $to_date   = $_POST['to_date'];
  $filterQuery = "WHERE DATE(p.created_at) BETWEEN '$from_date' AND '$to_date'";
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Doctor | View Prescriptions</title>
  <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
  <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
  <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="shortcut icon" href="assets/images/favicon.png" />
  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
</head>
<style>
  .detailsModal {
    width: 60%;
  }
</style>

<body>
  <div class="container-scroller">
    <?php include('include/sidebar.php'); ?>

    <div class="container-fluid page-body-wrapper">
      <?php include('include/header.php'); ?>
      <div class="main-panel">
        <div class="content-wrapper">

          <!-- Page Title -->

          <div class="card shadow mt-4">

            <div class="card-header bg-primary text-white">
              <h3 class="mb-0">Doctor | View Prescriptions</h3>
            </div>

            <div class="card-body">
              <?php
              if (isset($_SESSION['msg'])) {
                echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                unset($_SESSION['msg']);
              }
              ?>

              <!-- Date Filter -->
              <form method="post" class="form-inline mb-4">
                <label class="mr-2">From:</label>
                <input type="date" name="from_date" class="form-control mr-3" value="<?= $from_date; ?>">
                <label class="mr-2">To:</label>
                <input type="date" name="to_date" class="form-control mr-3" value="<?= $to_date; ?>">
                <button type="submit" class="btn btn-primary">Filter</button>
                <a href="view-prescription.php" class="btn btn-danger ml-2">Reset</a>
              </form>

              <div class="row">
                <div class="col-md-12">
                  <table id="prescriptionTable" class="table table-striped table-bordered">
                    <thead class="thead-dark">
                      <tr>
                        <th>SNO</th>
                        <th>Patient</th>
                        <th>Notes</th>
                        <th>Revisit Date</th>
                        <th>Created Date</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $query = "
                    SELECT p.id AS pid, u.fullName AS pname, p.notes, p.scan, p.lab,
                           p.revisit_date, p.created_at
                    FROM prescriptions p
                    JOIN users u ON p.patient_id = u.id
                    $filterQuery
                    ORDER BY p.id DESC";
                      $result = mysqli_query($con, $query);
                      $cnt = 1;
                      if (mysqli_num_rows($result) == 0) {
                        echo "<tr><td colspan='6' class='text-center text-danger'>No prescriptions found.</td></tr>";
                      } else {
                        while ($row = mysqli_fetch_assoc($result)) {
                          $revisitFormatted = !empty($row['revisit_date']) ? date("d/m/Y", strtotime($row['revisit_date'])) : '';
                          $createdFormatted = !empty($row['created_at']) ? date("d/m/Y h:i A", strtotime($row['created_at'])) : '';
                      ?>
                          <tr>
                            <td><?= $cnt++; ?></td>
                            <td><?= htmlentities($row['pname']); ?></td>
                            <td><?= htmlentities(substr($row['notes'], 0, 50)); ?>...</td>
                            <td><?= $revisitFormatted; ?></td>
                            <td><?= $createdFormatted; ?></td>
                            <td>
                              <button class="btn btn-info btn-sm view-details"
                                data-toggle="modal" data-target="#detailsModal"
                                data-id="<?= $row['pid']; ?>"
                                data-patient="<?= htmlentities($row['pname']); ?>"
                                data-notes="<?= htmlentities($row['notes']); ?>"
                                data-scan="<?= htmlentities($row['scan']); ?>"
                                data-lab="<?= htmlentities($row['lab']); ?>"
                                data-revisit="<?= $revisitFormatted; ?>"
                                data-created="<?= $createdFormatted; ?>">
                                View
                              </button>
                              <a href="edit_prescription.php?prescription_id=<?= $row['pid']; ?>"
                                class="btn btn-warning btn-sm">
                                Edit
                              </a>

                            </td>

                          </tr>
                      <?php
                        }
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <!-- Details Modal -->
          <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg detailsModal" role="document">
              <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                  <h5 class="modal-title">Prescription Details</h5>
                  <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                  <h5>Prescription Info</h5>
                  <table class="table table-bordered">
                    <tr>
                      <th>Patient</th>
                      <td id="dPatient"></td>
                    </tr>
                    <tr>
                      <th>Notes</th>
                      <td id="dNotes"></td>
                    </tr>
                    <tr>
                      <th>Scan</th>
                      <td id="dScan"></td>
                    </tr>
                    <tr>
                      <th>Lab</th>
                      <td id="dLab"></td>
                    </tr>
                    <tr>
                      <th>Revisit</th>
                      <td id="dRevisit"></td>
                    </tr>
                    <tr>
                      <th>Created Date</th>
                      <td id="dCreated"></td>
                    </tr>
                  </table>
                  <h5 class="mt-4">Medicines</h5>
                  <div id="medicineDetails">Loading...</div>
                </div>
              </div>
            </div>
          </div>

        </div>
        <?php include('include/footer.php'); ?>
      </div>
    </div>
  </div>

  <!-- JS -->
  <script src="assets/vendors/js/vendor.bundle.base.js"></script>
  <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
  <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

  <script>
    $(document).ready(function() {
      $('#prescriptionTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 10,
        "lengthMenu": [
          [5, 10, 25, 50, -1],
          [5, 10, 25, 50, "All"]
        ]
      });

      $(document).on("click", ".view-details", function() {
        $("#dPatient").text($(this).data("patient"));
        $("#dNotes").text($(this).data("notes"));
        $("#dScan").text($(this).data("scan"));
        $("#dLab").text($(this).data("lab"));
        $("#dRevisit").text($(this).data("revisit"));
        $("#dCreated").text($(this).data("created"));

        var prescriptionId = $(this).data("id");
        $("#medicineDetails").html("Loading...");
        $.get("fetch-medicines.php", {
          pid: prescriptionId
        }, function(data) {
          $("#medicineDetails").html(data);
        });
      });
    });
  </script>
</body>

</html>