<?php
session_start();
include('include/config.php');
error_reporting(0);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Manage In-Patients</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css"/>
</head>
<body>
<div id="app">
<?php include('include/sidebar.php'); ?>
<div class="app-content">
<?php include('include/header.php'); ?>

<!-- Start: Page Content -->
<div class="main-content">
    <div class="wrap-content container" id="container">
        <section id="page-title">
            <div class="row">
                <div class="col-sm-8">
                    <h1 class="mainTitle">Doctor | Manage In-Patients</h1>
                </div>
            </div>
        </section>
<a href="manage-patient.php" class="btn btn-secondary mb-3">← Back to Manage  Patient</a>

        <div class="container-fluid container-fullw bg-white">
            <div class="row">
                <div class="col-md-12">
                    <!-- <h4 class="over-title margin-bottom-15">Patient <span class="text-bold">List with Bed Details</span></h4> -->

                    <table class="table table-hover" id="sample-table-1">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Patient Name</th>
                                <th>Contact</th>
                                <th>Email</th>
                                <th>Gender</th>
                                <th>Address</th>
                                <th>State</th>
                                <th>City</th>
                                <th>Ward</th>
                                <th>Room No</th>
                                <th>Bed No</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        $sql = mysqli_query($con, "
                            SELECT ip.*, ra.room_no, ra.dname, ra.bed_no 
                            FROM in_patient ip 
                            LEFT JOIN room_allocation ra ON ra.patient_id = ip.id 
                            ORDER BY ip.id DESC
                        ");
                        $cnt = 1;
                        while ($row = mysqli_fetch_assoc($sql)) {
                        ?>
                            <tr>
                                <td><?php echo $cnt; ?>.</td>
                                <td><?php echo htmlentities($row['fullName']); ?></td>
                                <td><?php echo htmlentities($row['patcontact']); ?></td>
                                <td><?php echo htmlentities($row['patemail']); ?></td>
                                <td><?php echo htmlentities($row['gender']); ?></td>
                                <td><?php echo htmlentities($row['pataddress']); ?></td>
                                <td><?php echo htmlentities($row['state']); ?></td>
                                <td><?php echo htmlentities($row['city']); ?></td>
                                <td><?php echo htmlentities($row['dname'] ?? 'Not Assigned'); ?></td>
                                <td><?php echo htmlentities($row['room_no'] ?? 'Not Assigned'); ?></td>
                                <td><?php echo htmlentities($row['bed_no'] ?? 'Not Assigned'); ?></td>
                            </tr>
                        <?php 
                            $cnt++; 
                        } 
                        ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<?php include('include/footer.php'); ?>
<?php include('include/setting.php'); ?>
</div>

<!-- JS Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function() {
        $('#sample-table-1').DataTable();
    });
</script>
</body>
</html>
