<?php
include('include/config.php');

if (!isset($_GET['pid']) || empty($_GET['pid'])) {
    die("Invalid request");
}

$pid = intval($_GET['pid']);

// Prepare SQL to avoid SQL injection
$stmt = $con->prepare("
    SELECT 
        pid,
        GROUP_CONCAT(test_name SEPARATOR ', ') AS test_names,
        MAX(notes) AS notes,
        MAX(created_at) AS created_at
    FROM lab_tests
    WHERE pid = ?
    GROUP BY pid
");
$stmt->bind_param("i", $pid);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | View Lab Test Details</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet">
    <link href="vendor/select2/select2.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <style>
        .btn-primary {
            margin-left : 980px;
        }
           
        </style>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>

        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Lab Test Details</h1>
                        </div>
                        <ol class="breadcrumb">
                            <li><span>Doctor</span></li>
                            <li class="active"><span>Lab Test Details</span></li>
                        </ol>
                    </div>
                </section>
<br><br>
                <div class="text-end mb-3">
                    <button onclick="printSection('print-area')" class="btn btn-primary">
                        <i class="ti-printer"></i> Print
                    </button>
                </div>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="print-area" class="container mt-4">
                                <h3>Prescription Lab Test Details</h3>
                                <table class="table table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Prescription ID</th>
                                            <th>Test Name(s)</th>
                                            <th>Notes</th>
                                            <th>Created At</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if ($row = mysqli_fetch_assoc($result)) { ?>
                                        <tr>
                                            <td><?= htmlspecialchars($row['pid']); ?></td>
                                            <td><?= htmlspecialchars($row['test_names']); ?></td>
                                            <td><?= nl2br(htmlspecialchars($row['notes'])); ?></td>
                                            <td><?= htmlspecialchars($row['created_at']); ?></td>
                                        </tr>
                                        <?php } else { ?>
                                        <tr>
                                            <td colspan="4" class="text-center text-danger">No lab test records found for this prescription.</td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                                <a href="view-labtest.php" class="btn btn-secondary">Back</a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-md-12">
                    <div class="panel panel-white"></div>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="vendor/autosize/autosize.min.js"></script>
<script src="vendor/selectFx/classie.js"></script>
<script src="vendor/selectFx/selectFx.js"></script>
<script src="vendor/select2/select2.min.js"></script>
<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="assets/js/form-elements.js"></script>

<script>
    jQuery(document).ready(function () {
        Main.init();
        FormElements.init();
    });

    function printSection(divId) {
        var printContents = document.getElementById(divId).innerHTML;
        var win = window.open('', '', 'height=700,width=900');
        win.document.write('<html><head><title>Print</title>');
        win.document.write('<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">');
        win.document.write('<style>table{width:100%;border-collapse:collapse}th,td{border:1px solid #000;padding:8px;text-align:left;}</style>');
        win.document.write('</head><body>');
        win.document.write(printContents);
        win.document.write('</body></html>');
        win.document.close();
        win.print();
    }
</script>
</body>
</html>
