<?php
session_start();
error_reporting(E_ALL);
include('include/config.php');

// Insert Admission
if (isset($_POST['submit'])) {
    $patient_id = $_POST['patient_id'];
    $admission_date = $_POST['admission_date'];
    $admission_reason = $_POST['admission_reason'];
    $doctor_id = $_POST['doctor_id'];

    $stmt = $con->prepare("INSERT INTO admissions (patient_id, admission_date, admission_reason, doctor_id) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("issi", $patient_id, $admission_date, $admission_reason, $doctor_id);

    if ($stmt->execute()) {
        $_SESSION['msg'] = "Admission added successfully!";
    } else {
        $_SESSION['msg'] = "Error adding admission.";
    }

    $stmt->close();
    header("Location: recommend_admission.php"); // Prevent resubmission
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Doctor | Add Admission</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,600,700|Raleway:300,400,500,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="vendor/animate.css/animate.min.css">
    <link rel="stylesheet" href="vendor/perfect-scrollbar/perfect-scrollbar.min.css">
    <link rel="stylesheet" href="vendor/switchery/switchery.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Add Admission</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php
                    if (isset($_SESSION['msg'])) {
                        echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                        unset($_SESSION['msg']);
                    }
                    ?>
                    <div class="row">
                        <div class="col-md-8">
                            <form method="POST">
                                <div class="form-group">
                                    <label>Patient Name</label>
                                    <select name="patient_id" class="form-control" required>
                                        <option value="">Select Patient</option>
                                        <?php
                                        $res = $con->query("SELECT id, fullName FROM users ORDER BY fullName");
                                        while ($row = $res->fetch_assoc()) {
                                            echo "<option value='{$row['id']}'>{$row['fullName']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label>Admission Date</label>
                                    <input type="date" name="admission_date" class="form-control" required value="<?= date('Y-m-d') ?>">
                                </div>

                                <div class="form-group">
                                    <label>Admission Reason</label>
                                    <textarea name="admission_reason" class="form-control" rows="3" required></textarea>
                                </div>

                                <div class="form-group">
                                    <label>Doctor</label>
                                    <select name="doctor_id" class="form-control" required>
                                        <option value="">Select Doctor</option>
                                        <?php
                                        $doc = $con->query("SELECT id, doctorName FROM doctors ORDER BY doctorName");
                                        while ($row = $doc->fetch_assoc()) {
                                            echo "<option value='{$row['id']}'>{$row['doctorName']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>

                                <button type="submit" name="submit" class="btn btn-primary">Add Admission</button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS Libraries -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
