<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$msg = "";

// =============================
// Handle form submission
// =============================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $purchase_date   = $_POST['purchase_date'];
    $supplier_name   = $_POST['supplier_name'];
    $invoice_number  = $_POST['invoice_number'];
    $gst             = $_POST['gst'];
    $net             = $_POST['net'];
    $discount        = $_POST['discount'];
    $final_net       = $_POST['final_net_amount'];
    $payment_method  = $_POST['payment_method'];
    $created_by      = $_SESSION['id'] ?? 'system';

    // Items (arrays)
    $medicine_ids = $_POST['medicine_id'];
    $qtys         = $_POST['qty'];
    $rates        = $_POST['rate'];
    $totals       = $_POST['total'];

    // ✅ Insert into purchase table
    $stmt = $con->prepare("INSERT INTO medicine_purchase 
        (purchase_date, supplier_name, invoice_number, gst, net, discount, final_net_amount, payment_method, created_by) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssdddsss", 
        $purchase_date, $supplier_name, $invoice_number, 
        $gst, $net, $discount, $final_net, 
        $payment_method, $created_by
    );
    $stmt->execute();
    $purchase_id = $stmt->insert_id;
    $stmt->close();

    // ✅ Insert items
    $stmt2 = $con->prepare("INSERT INTO medicine_purchase_items (purchase_id, medicine_id, qty, rate, total) VALUES (?, ?, ?, ?, ?)");
    foreach ($medicine_ids as $i => $mid) {
        $q  = $qtys[$i];
        $r  = $rates[$i];
        $t  = $totals[$i];
        $stmt2->bind_param("iiidd", $purchase_id, $mid, $q, $r, $t);
        $stmt2->execute();
    }
    $stmt2->close();

    $msg = "✅ Medicine Purchase Entry added successfully!";
}

// =============================
// Auto-generate Invoice Number
// =============================
$query = mysqli_query($con, "SELECT invoice_number FROM medicine_purchase ORDER BY id DESC LIMIT 1");
$lastInvoice = mysqli_fetch_assoc($query);

if ($lastInvoice && !empty($lastInvoice['invoice_number'])) {
    $lastNumber = (int) filter_var($lastInvoice['invoice_number'], FILTER_SANITIZE_NUMBER_INT);
    $newNumber = $lastNumber + 1;
} else {
    $newNumber = 1;
}

$invoice_number = "MP" . date("Y") . str_pad($newNumber, 4, "0", STR_PAD_LEFT);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Medicine Purchase Entry</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <style>
        table { width:100%; border-collapse: collapse; margin-bottom: 10px; }
        table, th, td { border: 1px solid #ccc; padding: 6px; }
    </style>
    <script>
    function addRow() {
        let table = document.getElementById("itemsTable");
        let row = table.insertRow(-1);
        row.innerHTML = `
            <td>
                <select name="medicine_id[]" class="form-select" required>
                    <option value="">Select Medicine</option>
                    <?php
                    $res = $con->query("SELECT id, name FROM medicine");
                    while ($row = $res->fetch_assoc()) {
                        echo "<option value='{$row['id']}'>{$row['name']}</option>";
                    }
                    ?>
                </select>
            </td>
            <td><input type="number" name="qty[]" step="1" value="1" required></td>
            <td><input type="number" name="rate[]" step="0.01" required></td>
            <td><input type="number" name="total[]" step="0.01" required></td>
            <td><button type="button" onclick="this.parentNode.parentNode.remove()">❌</button></td>
        `;
    }
    </script>
</head>
<body>
       <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">
<div class="container mt-4">
    <h2>💊 Medicine Purchase Entry</h2>
    <p style="color:green;"><?= $msg ?></p>

    <form method="POST">
        <div class="row mb-3">
            <div class="col-md-4">
                <label>Purchase Date</label>
                <input type="date" name="purchase_date" class="form-control" required value="<?= date('Y-m-d') ?>">
            </div>
            <div class="col-md-4">
                <label>Supplier Name</label>
                <input type="text" name="supplier_name" class="form-control" required>
            </div>
            <div class="col-md-4">
                <label>Invoice No</label>
                <input type="text" name="invoice_number" class="form-control" value="<?= $invoice_number ?>" readonly>
            </div>
        </div>

        <h4>Medicine Items</h4>
        <table id="itemsTable">
            <tr>
                <th>Medicine</th>
                <th>Qty</th>
                <th>Rate</th>
                <th>Total</th>
                <th>Action</th>
            </tr>
            <tr>
                <td>
                    <select name="medicine_id[]" class="form-select" required>
                        <option value="">Select Medicine</option>
                        <?php
                        $res = $con->query("SELECT id, name FROM medicine");
                        while ($row = $res->fetch_assoc()) {
                            echo "<option value='{$row['id']}'>{$row['name']}</option>";
                        }
                        ?>
                    </select>
                </td>
                <td><input type="number" name="qty[]" step="1" value="1" required></td>
                <td><input type="number" name="rate[]" step="0.01" required></td>
                <td><input type="number" name="total[]" step="0.01" required></td>
                <td><button type="button" onclick="this.parentNode.parentNode.remove()">❌</button></td>
            </tr>
        </table>
        <button type="button" onclick="addRow()" class="btn btn-sm btn-success">➕ Add Medicine</button>
        <hr>

        <div class="row mb-3">
            <div class="col-md-3">
                <label>GST</label>
                <input type="number" name="gst" step="0.01" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Net</label>
                <input type="number" name="net" step="0.01" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Discount</label>
                <input type="number" name="discount" step="0.01" value="0.00" class="form-control">
            </div>
            <div class="col-md-3">
                <label>Final Net</label>
                <input type="number" name="final_net_amount" step="0.01" class="form-control">
            </div>
        </div>

        <div class="mb-3">
            <label>Payment Method</label>
            <select name="payment_method" class="form-control">
                <option>Cash</option>
                <option>Card</option>
                <option>UPI</option>
                <option>Credit</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">💾 Save Purchase</button>
    </form>
</div>
</body>
</html>
 <?php include('include/footer.php'); ?>

            </div>
        </div>

    </div>

    <!-- Scripts -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <!-- endinject -->
    <!-- Custom js for this page -->
    <script src="assets/js/dashboard.js"></script>
<script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendor/modernizr/modernizr.js"></script>
    <script src="vendor/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="vendor/switchery/switchery.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#example1').DataTable();
        });
    </script>
    <script src="assets/js/main.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
        });
    </script>
</body>

</html>