<?php
include 'include/config.php';

// Validate and sanitize the ID
if (isset($_GET['pid']) && is_numeric($_GET['pid'])) {
    $pid = (int)$_GET['pid'];

    // Fetch prescription details
    $pres = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM prescriptions WHERE pid = $pid"));
    
    if (!$pres) {
        echo "<p>Prescription not found.</p>";
        exit;
    }

    // Fetch associated medicines and lab tests
    $items = mysqli_query($con, "SELECT * FROM prescription_items WHERE pid = '$pid'");
    $tests = mysqli_query($con, "SELECT * FROM lab_tests WHERE pid = '$pid'");
} else {
    echo "<p>Invalid Prescription ID.</p>";
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Prescription Details</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        h2, h3 { margin-bottom: 10px; }
        ul { list-style-type: disc; margin-left: 20px; }
        button { margin-top: 20px; padding: 10px 15px; font-size: 16px; }
    </style>
</head>
<body>

<h2>Prescription ID: <?= htmlspecialchars($pres['id']) ?></h2>
<p><strong>Patient ID:</strong> <?= htmlspecialchars($pres['patient_id']) ?></p>
<p><strong>Diagnosis:</strong> <?= htmlspecialchars($pres['diagnosis']) ?></p>
<p><strong>Date:</strong> <?= htmlspecialchars($pres['prescription_date']) ?></p>

<h3>Medicines:</h3>
<ul>
<?php while ($row = mysqli_fetch_assoc($items)): ?>
    <li><?= htmlspecialchars($row['medicine_name']) ?> - <?= htmlspecialchars($row['dosage']) ?> for <?= htmlspecialchars($row['duration']) ?></li>
<?php endwhile; ?>
</ul>

<h3>Suggested Lab Tests:</h3>
<ul>
<?php while ($row = mysqli_fetch_assoc($tests)): ?>
    <li><?= htmlspecialchars($row['test_name']) ?> - <?= htmlspecialchars($row['notes']) ?></li>
<?php endwhile; ?>
</ul>

<button onclick="window.print()">Print</button>

</body>
</html>
