<?php
session_start();
error_reporting(0);
include('include/config.php');

if (isset($_GET['delid'])) {
    $delid = (int)$_GET['delid'];

    $stmt = mysqli_prepare($con, "DELETE FROM op_patients WHERE id = ?");
    mysqli_stmt_bind_param($stmt, "i", $delid);
    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['msg'] = "Schedule deleted successfully.";
    } else {
        $_SESSION['msg'] = "Error deleting schedule.";
    }
    mysqli_stmt_close($stmt);

    header("Location: manage-oppatient.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Manage OUT Patients</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
    <link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">		
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <!-- start: PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Manage OUT Patients</h1>
                        </div>
                        <!-- <ol class="breadcrumb">
                            <li><span>Doctor</span></li>
                            <li class="active"><span>Manage OUT Patients</span></li>
                        </ol> -->
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <h5 class="over-title margin-bottom-15">Manage <span class="text-bold">Patients</span></h5>

                            <table class="table table-hover" id="sample-table-1">
                                <thead>
                                    <tr>
                                        <th class="center">NO</th>
                                        <th>Queue No</th>
                                        <th>Doctor Specialization</th>
                                        <th>Patient Name</th>
                                        <th>Contact Number</th>
                                        <!-- <th>Alternate Number</th> -->
                                        <th>Email</th>
                                        <th>Address</th>
                                        <!-- <th>Pincode</th>
                                        <th>State</th> -->
                                        <th>Country</th>
                                        <th>Appointment Date</th>
                                        <th>Appointment Time</th>
                                        <!-- <th>Status</th> -->
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $docid = $_SESSION['id'];
                                    $sql = mysqli_query($con, "SELECT * FROM op_patients WHERE doctorid='$doctorid'");
                                    $cnt = 1;
                                    while ($row = mysqli_fetch_array($sql)) {
                                        ?>
                                        <tr>
                                            <td class="center"><?php echo $cnt; ?>.</td>
                                            <td><?php echo htmlspecialchars($row['queue_no']); ?></td>
                                            <td><?php echo htmlspecialchars($row['doctorSpecialization']); ?></td>
                                            <td><?php echo htmlspecialchars($row['patname']); ?></td>
                                            <td><?php echo htmlspecialchars($row['C_number']); ?></td>
                                            <!-- <td><?php echo htmlspecialchars($row['Alternate_number']); ?></td> -->
                                            <td><?php echo htmlspecialchars($row['Mail']); ?></td>
                                            <td><?php echo htmlspecialchars($row['Address']); ?></td>
                                            <!-- <td><?php echo htmlspecialchars($row['Pincode']); ?></td>
                                            <td><?php echo htmlspecialchars($row['State']); ?></td> -->
                                            <td><?php echo htmlspecialchars($row['Country']); ?></td>
                                            <td><?php echo htmlspecialchars($row['appdate']); ?></td>
                                            <td><?php echo htmlspecialchars($row['apptime']); ?></td>
                                            <!-- <td><?php echo htmlspecialchars($row['status']); ?></td> -->
                                            <td>
                                            <a href="view-oppatient.php?viewid=<?= $row['id'] ?>" class="fa fa-eye"></a>

<!-- <a href="viewmedi.php?id=<?php echo $row['id']; ?>"><i class="fa fa-eye"></i></a> -->
<a href="edit-oppatient.php?editid=<?php echo $row['id']; ?>" class="btn btn-transparent btn-xs" tooltip-placement="top" tooltip="Edit"><i class="fa fa-pencil"></i></a>
<a href="manage-oppatient.php?delid=<?php echo $row['id'];?>" onClick="return confirm('Are you sure you want to delete this medicine?');" class="btn btn-transparent btn-xs" tooltip-placement="top" tooltip="Delete"><i class="fa fa-trash"></i></a>

                                                <!-- <a href="edit-oppatient.php?editid=<?php echo $row['id']; ?>" class="btn btn-primary btn-sm" target="_blank">Edit</a>
                                                <a href="view-oppatient.php?viewid=<?php echo $row['id']; ?>" class="btn btn-warning btn-sm" target="_blank">View</a> -->
                                            </td>
                                        </tr>
                                        <?php
                                        $cnt++;
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
<script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="vendor/autosize/autosize.min.js"></script>
<script src="vendor/selectFx/classie.js"></script>
<script src="vendor/selectFx/selectFx.js"></script>
<script src="vendor/select2/select2.min.js"></script>
<script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
<script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
<script src="assets/js/main.js"></script>
<script src="assets/js/form-elements.js"></script>
<script>
    jQuery(document).ready(function() {
        Main.init();
        FormElements.init();
    });
</script>
</body>
</html>
