<?php
session_start();
include('include/config.php');

if (!isset($_POST['patient_id'])) {
    echo "Invalid request!";
    exit;
}

$patient_id = intval($_POST['patient_id']);

$query = mysqli_query($con, "
    SELECT p.*, d.doctorName
    FROM prescriptions p
    LEFT JOIN doctors d ON d.id = p.posted_by
    WHERE p.patient_id='$patient_id'
    ORDER BY p.created_at DESC
");

if (mysqli_num_rows($query) > 0) {
    while ($row = mysqli_fetch_assoc($query)) {
        echo '<div class="card mb-4">';
        echo '<div class="card-header bg-primary text-white">(Date: ' . date('d/m/Y', strtotime($row['created_at'])) . ')</div>';
        echo '<div class="card-body">';
        echo '<table class="table table-bordered">
                <tr><th>Doctor</th><td>' . htmlentities($row['doctorName']) . '</td></tr>
                <tr><th>Notes</th><td>' . htmlentities($row['notes']) . '</td></tr>
                <tr><th>Scan</th><td>' . htmlentities($row['scan']) . '</td></tr>
                <tr><th>Lab</th><td>' . htmlentities($row['lab']) . '</td></tr>
                <tr><th>Revisit Date</th><td>' . (!empty($row['revisit_date']) ? date("d/m/Y", strtotime($row['revisit_date'])) : '') . '</td></tr>
                <tr><th>Created Date</th><td>' . date('d/m/Y h:i A', strtotime($row['created_at'])) . '</td></tr>
              </table>';

        // Fetch medicines for this prescription
        $pid = $row['id'];
        $meds = mysqli_query($con, "SELECT * FROM prescription_items WHERE prescription_id = '$pid'");
        if (mysqli_num_rows($meds) > 0) {
            echo '<h5 class="mt-3">Medicines</h5>';
            echo '
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
                    <thead class="thead-dark">
                        <tr>
                            <th>Medicine</th>
                            <th>Strength</th>
                            <th>Dose</th>
                            <th>Duration</th>
                            <th>Food Advice</th>
                            <th>Morning</th>
                            <th>Afternoon</th>
                            <th>Evening</th>
                            <th>Night</th>
                        </tr>
                    </thead>
                    <tbody>';
            while ($m = mysqli_fetch_assoc($meds)) {
                echo '<tr>
                        <td>' . htmlentities($m['drug_name']) . '</td>
                        <td>' . htmlentities($m['strength']) . ' ' . htmlentities($m['strength_unit']) . '</td>
                        <td>' . htmlentities($m['dose']) . '</td>
                        <td>' . htmlentities($m['duration']) . ' ' . htmlentities($m['duration_unit']) . '</td>
                        <td>' . htmlentities($m['food_instruction']) . '</td>
                        <td>' . ($m['morning'] ? "✅" : "❌") . '</td>
                        <td>' . ($m['afternoon'] ? "✅" : "❌") . '</td>
                        <td>' . ($m['evening'] ? "✅" : "❌") . '</td>
                        <td>' . ($m['night'] ? "✅" : "❌") . '</td>
                      </tr>';
            }
            echo '</tbody>
            </table>
            </div>';
        } else {
            echo '<p class="text-muted">No medicines found for this prescription.</p>';
        }

        echo '</div></div>';
    }
} else {
    echo '<p>No history found for this patient.</p>';
}
?>
