<?php
session_start();
include("include/config.php");
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
  header('location:logout.php');
  exit();
}

$msg = "";
$userId = $_SESSION['id']; // same as login.php

if (isset($_POST['change'])) {
  $username        = trim($_POST['username']);
  $oldpassword     = trim($_POST['oldpassword']);
  $newpassword     = trim($_POST['newpassword']);
  $confirmpassword = trim($_POST['confirmpassword']);

  if (empty($username) || empty($oldpassword) || empty($newpassword) || empty($confirmpassword)) {
    $msg = "⚠️ All fields are required!";
  } elseif ($newpassword !== $confirmpassword) {
    $msg = "❌ New passwords do not match!";
  } else {
    // Fetch user record
    $stmt = $con->prepare("SELECT password FROM user_master WHERE id=? AND username=?");
    $stmt->bind_param("is", $userId, $username);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows > 0) {
      $row = $res->fetch_assoc();

      // Verify old password
      if (password_verify($oldpassword, $row['password'])) {
        $hashed_password = password_hash($newpassword, PASSWORD_DEFAULT);
        $update = $con->prepare("UPDATE user_master SET password=? WHERE id=?");
        $update->bind_param("si", $hashed_password, $userId);

        if ($update->execute()) {
          $msg = "✅ Password changed successfully!";
        } else {
          $msg = "❌ Failed to update password.";
        }
        $update->close();
      } else {
        $msg = "❌ Old password is incorrect!";
      }
    } else {
      $msg = "❌ User not found!";
    }
    $stmt->close();
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <title>Doctor | Reports</title>
  <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
  <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
  <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
  <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
  <div class="container-scroller">
    <?php include('include/sidebar.php'); ?>

    <div class="container-fluid page-body-wrapper">
      <?php include('include/header.php'); ?>

      <div class="main-panel">
        <div class="content-wrapper">

          <div class="card shadow mt-4">
            <div class="card-header bg-primary text-white">
              <h3 class="mb-0">Change Password</h3>
            </div>
            <div class="card-body">



              <?php if (!empty($msg)) { ?>
                <div class="alert alert-info"><?php echo htmlentities($msg); ?></div>
              <?php } ?>

              <form method="POST">
                <div class="form-group mb-3">
                  <label for="username">Doctor Name</label>
                  <input type="text" name="username" id="username"
                    class="form-control"
                    value="<?php echo htmlentities($_SESSION['username'] ?? ''); ?>" required>
                </div>

                <div class="form-group mb-3">
                  <label for="oldpassword">Old Password</label>
                  <input type="password" name="oldpassword" id="oldpassword" class="form-control" required>
                </div>

                <div class="form-group mb-3">
                  <label for="newpassword">New Password</label>
                  <input type="password" name="newpassword" id="newpassword" class="form-control" required>
                </div>

                <div class="form-group mb-3">
                  <label for="confirmpassword">Confirm Password</label>
                  <input type="password" name="confirmpassword" id="confirmpassword" class="form-control" required>
                </div>

                <div class="text-end">
                  <button type="submit" name="change" class="btn btn-primary">Update Password</button>
                </div>
              </form>
            </div>
          </div>

        </div> <!-- container -->
        <?php include('include/footer.php'); ?>

      </div>
    </div>
  </div>

  <!-- JS -->
  <script src="assets/vendors/js/vendor.bundle.base.js"></script>
  <!-- endinject -->
  <!-- Plugin js for this page -->
  <script src="assets/vendors/chart.js/Chart.min.js"></script>
  <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
  <script src="assets/vendors/flot/jquery.flot.js"></script>
  <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
  <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
  <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
  <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
  <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
  <!-- End plugin js for this page -->
  <!-- inject:js -->
  <script src="assets/js/off-canvas.js"></script>
  <script src="assets/js/hoverable-collapse.js"></script>
  <script src="assets/js/misc.js"></script>
  <script>
    $(document).ready(function() {
      $(".main-navigation-menu li > a").click(function(e) {
        var parentLi = $(this).parent("li");

        // If this menu has a submenu
        if (parentLi.find(".sub-menu").length > 0) {
          e.preventDefault(); // Prevent going to link

          // Toggle submenu
          parentLi.toggleClass("open");
          parentLi.find(".sub-menu").slideToggle(200);

          // Close other open menus (optional)
          parentLi.siblings().removeClass("open").find(".sub-menu").slideUp(200);
        }
      });
    });
  </script>

</body>

</html>