<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/config.php');

$isEdit = isset($_GET['id']) && is_numeric($_GET['id']);
$report = [
    'patient_id' => '',
    'result' => '',
    'report_date' => '',
    'doctor_name' => ''
];

if ($isEdit) {
    $report_id = intval($_GET['id']);
    $query = "SELECT * FROM lab_report WHERE id = ?";
    $stmt = mysqli_prepare($con, $query);
    mysqli_stmt_bind_param($stmt, 'i', $report_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $report = mysqli_fetch_assoc($result);
    mysqli_stmt_close($stmt);
}

// Handle form submission (both Add and Edit)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $patient_id = $_POST['fullName'];
    $result = $_POST['result'];
    $report_date = $_POST['report_date'];
    $doctor_id = $_POST['doctorName'];

    // Fetch full names
    $stmt1 = $con->prepare("SELECT fullName FROM users WHERE id = ?");
    $stmt1->bind_param("i", $patient_id);
    $stmt1->execute();
    $stmt1->bind_result($fullName);
    $stmt1->fetch();
    $stmt1->close();

    $stmt2 = $con->prepare("SELECT doctorName FROM doctors WHERE id = ?");
    $stmt2->bind_param("i", $doctor_id);
    $stmt2->execute();
    $stmt2->bind_result($doctorName);
    $stmt2->fetch();
    $stmt2->close();

    if ($isEdit) {
        $query = "UPDATE lab_report SET fullName = ?, result = ?, report_date = ?, doctorName = ? WHERE id = ?";
        $stmt = mysqli_prepare($con, $query);
        mysqli_stmt_bind_param($stmt, 'ssssi', $fullName, $result, $report_date, $doctorName, $report_id);
    } else {
        $query = "INSERT INTO lab_report (fullName, result, report_date, doctorName) VALUES (?, ?, ?, ?)";
        $stmt = mysqli_prepare($con, $query);
        mysqli_stmt_bind_param($stmt, 'ssss', $fullName, $result, $report_date, $doctorName);
    }

    if (mysqli_stmt_execute($stmt)) {
        echo "<script>alert('Lab report " . ($isEdit ? "updated" : "submitted") . " successfully'); window.location.href='edit_lab.php';</script>";
        exit();
    } else {
        echo "<script>alert('Error saving lab report.');</script>";
    }

    mysqli_stmt_close($stmt);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Laboratory | <?= $isEdit ? "Edit" : "Add" ?> Lab Report</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color">
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Laboratory | <?= $isEdit ? "Edit" : "Add" ?> Lab Report</h1>
                        </div>
                    </div>
                </section>
    <a href="view_reports.php" class="btn btn-secondary mb-3">← Back to Manage  Patient</a>                           

                <div class="container mt-5">
                    <form method="post">
                        <div class="form-group">
                            <label for="patient_id">Select Patient</label>
                            <select name="fullName" class="form-control" required>
                                <option value="">-- Select Patient --</option>
                                <?php
                                $res = mysqli_query($con, "SELECT id, fullName FROM users ORDER BY fullName");
                                while ($row = mysqli_fetch_assoc($res)) {
                                    $selected = ($row['fullName'] == $report['fullName']) ? 'selected' : '';
                                    echo "<option value='{$row['id']}' $selected>{$row['fullName']}</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Test Result</label>
                            <select name="result" class="form-control" required>
                                <option value="">Select Result</option>
                                <option value="Positive" <?= ($report['result'] == 'Positive') ? 'selected' : '' ?>>Positive</option>
                                <option value="Negative" <?= ($report['result'] == 'Negative') ? 'selected' : '' ?>>Negative</option>
                                <option value="Inconclusive" <?= ($report['result'] == 'Inconclusive') ? 'selected' : '' ?>>Inconclusive</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Report Date</label>
                            <input type="date" name="report_date" class="form-control" value="<?= htmlentities($report['report_date']) ?>" required>
                        </div>

                        <div class="form-group">
                            <label for="doctor_id">Select Doctor</label>
                            <select name="doctorName" class="form-control" required>
                                <option value="">-- Select Doctor --</option>
                                <?php
                                $res = mysqli_query($con, "SELECT id, doctorName FROM doctors ORDER BY doctorName");
                                while ($row = mysqli_fetch_assoc($res)) {
                                    $selected = ($row['doctorName'] == $report['doctorName']) ? 'selected' : '';
                                    echo "<option value='{$row['id']}' $selected>{$row['doctorName']}</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary"><?= $isEdit ? "Update" : "Submit" ?> Report</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
