<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);
include('include/config.php');

// Validate ID
if (!isset($_GET['editid']) || !is_numeric($_GET['editid'])) {
    echo "<script>alert('Invalid Summary ID'); window.location.href='view_discharge_summary.php';</script>";
    exit;
}

$id = intval($_GET['editid']);

// Fetch existing discharge summary
$stmt = $con->prepare("SELECT * FROM discharge_summaries WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$summary = $result->fetch_assoc();
$stmt->close();

if (!$summary) {
    echo "<script>alert('Discharge summary not found'); window.location.href='view_discharge_summary.php';</script>";
    exit;
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $fullName = $_POST['fullName'];
    $admission_date = $_POST['admission_date'];
    $discharge_date = $_POST['discharge_date'];
    $diagnosis = $_POST['diagnosis'];
    $treatment_given = $_POST['treatment_given'];
    $remark = $_POST['remark'];

    $update = $con->prepare("UPDATE discharge_summaries SET fullName = ?, admission_date = ?, discharge_date = ?, diagnosis = ?, treatment_given = ?, remark = ? WHERE id = ?");
    $update->bind_param("ssssssi", $fullName, $admission_date, $discharge_date, $diagnosis, $treatment_given, $remark, $id);

    if ($update->execute()) {
        echo "<script>alert('Discharge summary updated successfully'); window.location.href='view_discharge_summary.php';</script>";
        exit;
    } else {
        echo "<script>alert('Update failed');</script>";
    }

    $update->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Discharge Summary</title>
   <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
		<link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
		<link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
		<link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
		<link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
		<link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
		<link rel="stylesheet" href="assets/css/styles.css">
		<link rel="stylesheet" href="assets/css/plugins.css">
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Edit Discharge Summary</h1>
                        </div>
                    </div>
                </section>

                <a href="view_discharge_summary.php" class="btn btn-secondary mb-3">← Back to Manage Summaries</a>

                <div class="container">
                    <form method="post">
                        <div class="form-group">
                            <label for="fullName">Select Patient</label>
                            <select name="fullName" class="form-control" required>
                                <option value="">-- Select Patient --</option>
                                <?php
                                $res = mysqli_query($con, "SELECT fullName FROM users ORDER BY fullName");
                                while ($row = mysqli_fetch_assoc($res)) {
                                    $selected = ($row['fullName'] == $summary['fullName']) ? 'selected' : '';
                                    echo "<option value='{$row['fullName']}' $selected>{$row['fullName']}</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="admission_date">Admission Date</label>
                            <input type="date" name="admission_date" class="form-control" value="<?= htmlentities($summary['admission_date']) ?>" required>
                        </div>

                        <div class="form-group">
                            <label for="discharge_date">Discharge Date</label>
                            <input type="date" name="discharge_date" class="form-control" value="<?= htmlentities($summary['discharge_date']) ?>" required>
                        </div>

                        <div class="form-group">
                            <label for="diagnosis">Diagnosis</label>
                            <textarea name="diagnosis" class="form-control" rows="3" required><?= htmlentities($summary['diagnosis']) ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="treatment_given">Treatment Given</label>
                            <textarea name="treatment_given" class="form-control" rows="3" required><?= htmlentities($summary['treatment_given']) ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="remark">Remark</label>
                            <textarea name="remark" class="form-control" rows="3"><?= htmlentities($summary['remark']) ?></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary">Update Summary</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<!-- JS Scripts -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
