<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    echo "<script>alert('Please login to edit profile'); window.location.href='login.php';</script>";
    exit();
}

$doctorId = intval($_SESSION['id']);

// ✅ Fetch doctor data
$stmt = $con->prepare("SELECT * FROM doctors WHERE id=?");
$stmt->bind_param("i", $doctorId);
$stmt->execute();
$doctor = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$doctor) {
    echo "<script>alert('Invalid doctor account'); window.location.href='dashboard.php';</script>";
    exit();
}

// ✅ Handle update
if (isset($_POST['submit'])) {
    $username   = trim($_POST['username']);
    $doctorName = trim($_POST['doctorName']);
    $address    = trim($_POST['address']);
    $city       = trim($_POST['city']);
    $state      = trim($_POST['state']);
    $pincode    = trim($_POST['pincode']);
    $country    = trim($_POST['country']);
    $dob        = $_POST['dob'];
    $gender     = $_POST['gender'];
    $bloodgroup = $_POST['bloodgroup'];
    $contactno  = trim($_POST['contactno']);
    $docEmail   = trim($_POST['docEmail']);
    $profile_pic = $doctor['profile_pic'];

    // ✅ Handle file upload
    if (!empty($_FILES['profile_pic']['name'])) {
        $uploadDir = __DIR__ . "/uploads/";
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        $fileName = time() . "_" . preg_replace("/[^a-zA-Z0-9.]/", "_", basename($_FILES["profile_pic"]["name"]));
        $targetFile = $uploadDir . $fileName;
        $ext = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];

        if (in_array($ext, $allowed)) {
            if ($_FILES['profile_pic']['size'] <= 2 * 1024 * 1024) {
                if (move_uploaded_file($_FILES["profile_pic"]["tmp_name"], $targetFile)) {
                    if (!empty($doctor['profile_pic']) && file_exists($uploadDir . $doctor['profile_pic'])) {
                        unlink($uploadDir . $doctor['profile_pic']);
                    }
                    $profile_pic = $fileName;
                } else {
                    echo "<script>alert('Upload failed. Check folder permission.');</script>";
                }
            } else {
                echo "<script>alert('Image too large. Max 2MB allowed.');</script>";
            }
        } else {
            echo "<script>alert('Only JPG, JPEG, PNG, GIF allowed.');</script>";
        }
    }

    // ✅ Update query
    $update = $con->prepare("UPDATE doctors 
        SET username=?, doctorName=?, address=?, city=?, state=?, pincode=?, country=?, dob=?, gender=?, bloodgroup=?, contactno=?, docEmail=?, profile_pic=?, updationDate=NOW()
        WHERE id=?");
    $update->bind_param(
        "sssssssssssssi",
        $username,
        $doctorName,
        $address,
        $city,
        $state,
        $pincode,
        $country,
        $dob,
        $gender,
        $bloodgroup,
        $contactno,
        $docEmail,
        $profile_pic,
        $doctorId
    );

    if ($update->execute()) {
        echo "<script>alert('Profile updated successfully'); window.location.href='edit-profile.php';</script>";
        exit();
    } else {
        echo "<script>alert('Update failed. Try again.');</script>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title>Doctor | Edit Profile</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
    <style>
        .profile-img {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #ddd;
        }
    </style>
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>
        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>

            <div class="main-panel">
                <div class="content-wrapper">

                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">Edit Profile</h1>
                            </div>
                        </div>
                    </section>

                    <div class="container bg-white p-4 rounded shadow-sm">
                        <form method="post" enctype="multipart/form-data">
                            <!-- Profile Picture -->
                            <div class="mb-3 text-center">
                                <label class="form-label fw-bold">Profile Picture</label><br>
                                <?php if (!empty($doctor['profile_pic'])): ?>
                                    <img src="uploads/<?= htmlentities($doctor['profile_pic']); ?>" class="profile-img mb-2" id="preview">
                                <?php else: ?>
                                    <img src="assets/img/default-avatar.png" class="profile-img mb-2" id="preview">
                                <?php endif; ?>
                                <input type="file" name="profile_pic" class="form-control mt-2" accept="image/*" onchange="previewImage(event)">
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label>Username</label>
                                    <input type="text" name="username" class="form-control" value="<?= htmlentities($doctor['username']); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Doctor Name</label>
                                    <input type="text" name="doctorName" class="form-control" value="<?= htmlentities($doctor['doctorName']); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Email</label>
                                    <input type="email" name="docEmail" class="form-control" value="<?= htmlentities($doctor['docEmail']); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Contact No</label>
                                    <input type="text" name="contactno" maxlength="10" class="form-control" value="<?= htmlentities($doctor['contactno']); ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Address</label>
                                    <textarea name="address" class="form-control"><?= htmlentities($doctor['address']); ?></textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>City</label>
                                    <input type="text" name="city" class="form-control" value="<?= htmlentities($doctor['city']); ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>State</label>
                                    <select name="state" id="state" class="form-control" required>
                                        <option value="">Select State</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Pincode</label>
                                    <input type="text" name="pincode" maxlength="6" class="form-control" value="<?= htmlentities($doctor['pincode']); ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Country</label>
                                    <select name="country" id="country" class="form-control" required>
                                        <option value="">Select Country</option>
                                        <option value="India" <?= $doctor['country']=="India" ? "selected" : "" ?>>India</option>
                                        <option value="USA" <?= $doctor['country']=="USA" ? "selected" : "" ?>>USA</option>
                                        <option value="UK" <?= $doctor['country']=="UK" ? "selected" : "" ?>>UK</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Date of Birth</label>
                                    <input type="date" name="dob" class="form-control" value="<?= htmlentities($doctor['dob']); ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Gender</label>
                                    <select name="gender" class="form-control">
                                        <option value="male" <?= $doctor['gender'] == 'male' ? 'selected' : ''; ?>>Male</option>
                                        <option value="female" <?= $doctor['gender'] == 'female' ? 'selected' : ''; ?>>Female</option>
                                        <option value="other" <?= $doctor['gender'] == 'other' ? 'selected' : ''; ?>>Other</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label>Blood Group</label>
                                    <select name="bloodgroup" class="form-control">
                                        <?php
                                        $groups = ['A+', 'A-', 'B+', 'B-', 'AB+', 'AB-', 'O+', 'O-'];
                                        foreach ($groups as $g) {
                                            $sel = ($doctor['bloodgroup'] == $g) ? 'selected' : '';
                                            echo "<option value='$g' $sel>$g</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>

                            <div class="text-end">
                                <button type="submit" name="submit" class="btn btn-primary">Update Profile</button>
                            </div>
                        </form>
                    </div>

                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="assets/js/main.js"></script>

    <script>
        function previewImage(event) {
            let reader = new FileReader();
            reader.onload = function() {
                document.getElementById('preview').src = reader.result;
            }
            reader.readAsDataURL(event.target.files[0]);
        }

        // Country-State data
        const statesByCountry = {
            "India": ["Tamil Nadu", "Kerala", "Karnataka", "Maharashtra", "Delhi", "Gujarat"],
            "USA": ["California", "Texas", "Florida", "New York", "Illinois"],
            "UK": ["England", "Scotland", "Wales", "Northern Ireland"]
        };

        function loadStates(country, selectedState = "") {
            let stateSelect = document.getElementById("state");
            stateSelect.innerHTML = '<option value="">Select State</option>';
            if (statesByCountry[country]) {
                statesByCountry[country].forEach(state => {
                    let opt = document.createElement("option");
                    opt.value = state;
                    opt.text = state;
                    if (state === selectedState) opt.selected = true;
                    stateSelect.appendChild(opt);
                });
            }
        }

        document.getElementById("country").addEventListener("change", function() {
            loadStates(this.value);
        });

        // Load doctor saved values
        window.onload = function() {
            loadStates("<?= $doctor['country']; ?>", "<?= $doctor['state']; ?>");
        };
    </script>
</body>
</html>
