<?php
session_start();
include('include/config.php');

// Fetch shift schedules with doctor names
$query = mysqli_query($con, "
    SELECT s.id, d.doctorName, s.day_id, s.start_time, s.end_time
    FROM doctor_shift_master s
    JOIN doctors d ON d.id = s.doc_id
");

// Prepare events for calendar
$events = [];
$dayMap = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
$currentWeekStart = strtotime('monday this week');

while ($row = mysqli_fetch_assoc($query)) {
    $dayIndex = (int)$row['day_id']; // 0 = Monday
    $doctor = $row['doctorName'];
    $startTime = $row['start_time'];
    $endTime = $row['end_time'];

    // Create full datetime for current week's day
    $eventDate = strtotime("+{$dayIndex} day", $currentWeekStart);
    $dateStr = date('Y-m-d', $eventDate);

    $events[] = [
        'title' => "$doctor ({$dayMap[$dayIndex]})",
        'start' => $dateStr . 'T' . $startTime,
        'end'   => $dateStr . 'T' . $endTime,
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Shift Calendar</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />

    <!-- FullCalendar CSS -->
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css" rel="stylesheet" />
    <style>
        #calendar {
            background: #fff;
            padding: 15px;
            border-radius: 8px;
        }
        .fc-toolbar-title {
            font-size: 22px;
            font-weight: bold;
        }
    </style>
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">

                <!-- PAGE TITLE -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Doctor | Shift Calendar</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="calendar"></div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?php include('include/footer.php'); ?>
<?php include('include/setting.php'); ?>

<!-- JS Libraries -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/main.js"></script>

<!-- FullCalendar JS -->
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>

<!-- Render Calendar -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const calendarEl = document.getElementById('calendar');

    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'timeGridWeek',
        height: 600,
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'timeGridWeek,dayGridMonth,listWeek'
        },
        events: <?php echo json_encode($events); ?>
    });

    calendar.render();
});
</script>
</body>
</html>
