<?php  
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/config.php');

$message = "";

// Fetch patient list
$patients = $con->prepare("SELECT id, fullName FROM users ORDER BY fullName");
$patients->execute();
$patientResult = $patients->get_result();

// Fetch doctor list
$doctors = $con->prepare("SELECT id, doctorName FROM doctors ORDER BY doctorName");
$doctors->execute();
$doctorResult = $doctors->get_result();

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $patient_id = $_POST['fullName'];
    $doctorName = $_POST['doctorName'];
    $admission_date = $_POST['admission_date'];
    $discharge_date = $_POST['discharge_date'];
    $diagnosis = $_POST['diagnosis'];
    $treatment_given = $_POST['treatment_given'];
    $remark = $_POST['remarks'];

    // Get patient full name
    $stmt = $con->prepare("SELECT fullName FROM users WHERE id = ?");
    $stmt->bind_param("i", $patient_id);
    $stmt->execute();
    $stmt->bind_result($fullName);
    $stmt->fetch();
    $stmt->close();

    // Insert discharge summary
    $insert = $con->prepare("INSERT INTO discharge_summaries 
        (fullName, doctorName, admission_date, discharge_date, diagnosis, treatment_given, remark) 
        VALUES (?, ?, ?, ?, ?, ?, ?)");
    $insert->bind_param("sssssss", $fullName, $doctorName, $admission_date, $discharge_date, $diagnosis, $treatment_given, $remark);

    if ($insert->execute()) {
        $_SESSION['msg'] = "✅ Discharge summary submitted successfully.";
        header("Location: dashboard.php");
        exit();
    } else {
        $message = "❌ Error: " . $insert->error;
    }

    $insert->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Discharge Summary Entry</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>
        <div class="main-content">
            <div class="wrap-content container" id="container">
                <!-- Page Title -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Discharge Summary Entry</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <?php if ($message): ?>
                        <div class="alert alert-danger"><?= $message ?></div>
                    <?php endif; ?>
                    <?php if (!empty($_SESSION['msg'])): ?>
                        <div class="alert alert-success"><?= htmlentities($_SESSION['msg']); unset($_SESSION['msg']); ?></div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-12">
                            <form method="POST" class="row g-3">
                                <div class="col-md-6">
                                    <label>Patient Name</label>
                                    <select name="fullName" class="form-control" required>
                                        <option value="">Select Patient</option>
                                        <?php while ($row = $patientResult->fetch_assoc()) { ?>
                                            <option value="<?= $row['id'] ?>"><?= htmlentities($row['fullName']) ?></option>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>Doctor Name</label>
                                    <select name="doctorName" class="form-control" required>
                                        <option value="">Select Doctor</option>
                                        <?php while ($row = $doctorResult->fetch_assoc()) { ?>
                                            <option value="<?= htmlentities($row['doctorName']) ?>"><?= htmlentities($row['doctorName']) ?></option>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label>Admission Date</label>
                                    <input type="date" name="admission_date" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>Discharge Date</label>
                                    <input type="date" name="discharge_date" class="form-control" required>
                                </div>

                                <div class="col-md-6">
                                    <label>Diagnosis</label>
                                    <textarea name="diagnosis" class="form-control" required></textarea>
                                </div>

                                <div class="col-md-6">
                                    <label>Treatment Given</label>
                                    <textarea name="treatment_given" class="form-control" required></textarea>
                                </div>

                                <div class="col-md-6">
                                    <label>Remarks</label>
                                    <textarea name="remarks" class="form-control"></textarea>
                                </div>

                                <div class="col-12 mt-3">
                                    <button type="submit" class="btn btn-primary">Submit Summary</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div><!-- container-fullw -->
            </div>
        </div>
    </div>

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/js/main.js"></script>
<script>
    jQuery(document).ready(function () {
        Main.init();
    });
</script>
</body>
</html>
