<?php
session_start();
include('include/config.php');
error_reporting(0);

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $Doctorspecialization = $_POST['Doctorspecialization'];
    $patname   = $_POST['patname'];
    $patcontact = $_POST['patcontact'];
    $patemail   = $_POST['patemail'];
    $gender     = $_POST['gender'];
    $pataddress = $_POST['pataddress'];
    $state      = $_POST['state'];
    $city       = $_POST['city'];

    $stmt = $con->prepare("INSERT INTO registration 
        (Doctorspecialization, patname, patcontact, patemail, gender, pataddress, state, city) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssss", $Doctorspecialization, $patname, $patcontact, $patemail, $gender, $pataddress, $state, $city);

    if ($stmt->execute()) {
        $_SESSION['msg'] = "✅ Patient info added successfully.";
    } else {
        $_SESSION['msg'] = "❌ Error: " . $stmt->error;
    }
    $stmt->close();

    header("Location: add_patient.php"); // Prevent resubmission
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor | Add Patient</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSS Links -->
    <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="vendor/fontawesome/css/font-awesome.min.css" rel="stylesheet">
    <link href="vendor/themify-icons/themify-icons.min.css" rel="stylesheet">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet">
    <link href="assets/css/styles.css" rel="stylesheet">
    <link href="assets/css/plugins.css" rel="stylesheet">
    <link href="assets/css/themes/theme-1.css" rel="stylesheet" id="skin_color" />
</head>
<body>
<div id="app">
    <?php include('include/sidebar.php'); ?>
    <div class="app-content">
        <?php include('include/header.php'); ?>

        <div class="main-content">
            <div class="wrap-content container" id="container">
                <!-- Page Title -->
                <section id="page-title">
                    <div class="row">
                        <div class="col-sm-8">
                            <h1 class="mainTitle">Patient | Add Patient</h1>
                        </div>
                    </div>
                </section>

                <div class="container-fluid container-fullw bg-white">
                    <!-- Flash Message -->
                    <?php if (!empty($_SESSION['msg'])): ?>
                        <div class="alert alert-info">
                            <?= htmlentities($_SESSION['msg']); unset($_SESSION['msg']); ?>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Doctor Specialization</label>
                                    <select name="Doctorspecialization" class="form-control" required>
                                        <option value="">Select Specialization</option>
                                        <?php
                                        $ret = mysqli_query($con, "SELECT * FROM doctorspecilization ORDER BY specilization");
                                        while ($row = mysqli_fetch_assoc($ret)) {
                                            echo '<option value="'.htmlentities($row['specilization']).'">'.htmlentities($row['specilization']).'</option>';
                                        }
                                        ?>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Patient Name</label>
                                    <input type="text" name="patname" class="form-control" placeholder="Enter Patient Name" required 
                                           onkeypress="return onlyLetters(event)">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Patient Contact</label>
                                    <input type="text" name="patcontact" class="form-control" placeholder="Enter Contact No" required maxlength="10" 
                                           onkeypress="return onlyNumbers(event)">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Patient Email</label>
                                    <input type="email" name="patemail" class="form-control" placeholder="Enter Email" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Gender</label>
                                    <select name="gender" class="form-control" required>
                                        <option value="">Select Gender</option>
                                        <option value="female">Female</option>
                                        <option value="male">Male</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Patient Address</label>
                                    <textarea name="pataddress" class="form-control" placeholder="Enter Address" required></textarea>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">State</label>
                                    <input type="text" name="state" class="form-control" placeholder="Enter State" required 
                                           onkeypress="return onlyLetters(event)">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">City</label>
                                    <input type="text" name="city" class="form-control" placeholder="Enter City" required 
                                           onkeypress="return onlyLetters(event)">
                                </div>

                                <div class="col-12">
                                    <button type="submit" name="submit" class="btn btn-primary">Add Patient</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div><!-- end container-fullw -->
            </div>
        </div><!-- end main-content -->
    </div><!-- end app-content -->

    <?php include('include/footer.php'); ?>
    <?php include('include/setting.php'); ?>
</div><!-- end app -->

<!-- JS -->
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.min.js"></script>
<script src="vendor/modernizr/modernizr.js"></script>
<script src="vendor/jquery-cookie/jquery.cookie.js"></script>
<script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="vendor/switchery/switchery.min.js"></script>
<script src="assets/js/main.js"></script>

<!-- Custom Validation -->
<script>
function onlyLetters(e) {
    var charCode = e.which ? e.which : e.keyCode;
    if ((charCode >= 65 && charCode <= 90) ||  // A-Z
        (charCode >= 97 && charCode <= 122) || // a-z
        charCode === 32) { // space
        return true;
    }
    return false;
}

function onlyNumbers(e) {
    var charCode = e.which ? e.which : e.keyCode;
    if (charCode >= 48 && charCode <= 57) { // 0-9
        return true;
    }
    return false;
}

jQuery(document).ready(function() {
    Main.init();
});
</script>
</body>
</html>
