<?php
session_start();
include "include/config.php"; // mysqli $con ready

$message = "";

if (isset($_POST['submit'])) {
    $code = trim($_POST['code']);
    $role_name = trim($_POST['role_name']);
    $company_name = trim($_POST['company_name']);
    $status = $_POST['status'];
    $created_by = $_SESSION['id'] ?? 0; // logged in user id
    $modified_by = $created_by;
    $modified_on = date("Y-m-d H:i:s");

    // check duplicate code
    $check = $con->prepare("SELECT id FROM role_master WHERE code=?");
    $check->bind_param("s", $code);
    $check->execute();
    $check->store_result();
    if ($check->num_rows > 0) {
        $message = "Role code already exists!";
    } else {
        $stmt = $con->prepare("INSERT INTO role_master (code, role_name, company_name, status, created_by, modified_by, modified_on) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param("sssissi", $code, $role_name, $company_name, $status, $created_by, $modified_by, $modified_on);

        if ($stmt->execute()) {
            $message = "Role added successfully!";
        } else {
            $message = "Error: " . $stmt->error;
        }
        $stmt->close();
    }
    $check->close();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manage roles</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">

                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-0">Add New Role</h3>
                        </div>
                        <div class="card-body">
                            <?php if ($message): ?>
                                <div class="alert <?= strpos($message, 'Error') !== false ? 'alert-danger' : 'alert-success' ?> alert-dismissible fade show" role="alert">
                                    <?= $message ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            <?php endif; ?>
                            <form method="post">
                                <div class="mb-3">
                                    <label class="form-label">Role Code *</label>
                                    <input type="text" name="code" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Role Name *</label>
                                    <input type="text" name="role_name" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <select name="status" class="form-select">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Company Name *</label>
                                    <input type="text" name="company_name" class="form-control" required>
                                </div>
                                <button type="submit" name="submit" class="btn btn-primary w-100">Add Role</button>
                            </form>
                        </div>
                    </div>

                    <!-- Optional: Role List Table -->
                    <div class="card shadow mt-4">
                        <div class="card-header bg-primary text-white">
                            <h3 class="mb-0">Existing Roles</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-striped">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>#</th>
                                        <th>Code</th>
                                        <th>Role Name</th>
                                        <th>Status</th>
                                        <th>Created By</th>
                                        <th>Modified On</th>
                                        <th>Actions</th> <!-- New Column -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $res = $con->query("SELECT * FROM role_master ORDER BY id DESC");
                                    $i = 1;
                                    while ($row = $res->fetch_assoc()):
                                    ?>
                                        <tr>
                                            <td><?= $i++ ?></td>
                                            <td><?= htmlspecialchars($row['code']) ?></td>
                                            <td><?= htmlspecialchars($row['role_name']) ?></td>
                                            <td><?= $row['status'] == 1 ? 'Active' : 'Inactive' ?></td>
                                            <td><?= $row['created_by'] ?></td>
                                            <td><?= $row['modified_on'] ?></td>
                                            <td>
                                                <a href="edit_role.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                                                <a href="delete_role.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure to delete this role?');">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>


                </div>

                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page -->
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <!-- End plugin js for this page -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
            FormElements.init();
        });
    </script>
    <script>
        // Initialize Select2 on the patient dropdown
        $(document).ready(function() {
            $('#patientSelect').select2({
                placeholder: "Search Patient Name",
                allowClear: true
            });
        });
    </script>

</body>

</html>