<?php
session_start();
include "include/config.php";

$id = $_GET['id'] ?? 0;

if (!$id) {
    header("Location: role_master.php");
    exit;
}

$message = "";

// Safe output helper
function e($value) {
    return htmlspecialchars($value ?? '', ENT_QUOTES, 'UTF-8');
}

// Fetch role
$stmt = $con->prepare("SELECT * FROM role_master WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$role = $res->fetch_assoc();
$stmt->close();

if (isset($_POST['submit'])) {
    $code = trim($_POST['code']);
    $role_name = trim($_POST['role_name']);
    $status = $_POST['status'];
    $modified_by = $_SESSION['id'] ?? 0;
    $modified_on = date("Y-m-d H:i:s");

    // Update query
    $stmt = $con->prepare("UPDATE role_master SET code=?, role_name=?, status=?, modified_by=?, modified_on=? WHERE id=?");
    $stmt->bind_param("ssissi", $code, $role_name, $status, $modified_by, $modified_on, $id);
    if ($stmt->execute()) {
        $message = "Role updated successfully!";
        header("Location: role_master.php");
        exit;
    } else {
        $message = "Error: " . $stmt->error;
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Edit Role</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="card shadow p-4">
                        <h3 class="mb-3">Edit Role</h3>
                        <?php if ($message): ?>
                            <div class="alert <?= strpos($message, 'Error') !== false ? 'alert-danger' : 'alert-success' ?>">
                                <?= e($message) ?>
                            </div>
                        <?php endif; ?>
                        <form method="post">
                            <div class="mb-3">
                                <label class="form-label">Role Code *</label>
                                <input type="text" name="code" class="form-control" required value="<?= e($role['code'] ?? '') ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Role Name *</label>
                                <input type="text" name="role_name" class="form-control" required value="<?= e($role['role_name'] ?? '') ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="1" <?= ($role['status'] ?? '') == 1 ? 'selected' : '' ?>>Active</option>
                                    <option value="0" <?= ($role['status'] ?? '') == 0 ? 'selected' : '' ?>>Inactive</option>
                                </select>
                            </div>
                            <button type="submit" name="submit" class="btn btn-primary">Update Role</button>
                            <a href="role_master.php" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
                <?php include('include/footer.php'); ?>
            </div>
        </div>
    </div>

    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="assets/vendors/chart.js/Chart.min.js"></script>
    <script src="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="assets/vendors/flot/jquery.flot.js"></script>
    <script src="assets/vendors/flot/jquery.flot.resize.js"></script>
    <script src="assets/vendors/flot/jquery.flot.categories.js"></script>
    <script src="assets/vendors/flot/jquery.flot.fillbetween.js"></script>
    <script src="assets/vendors/flot/jquery.flot.stack.js"></script>
    <script src="assets/vendors/flot/jquery.flot.pie.js"></script>
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</body>

</html>
