<?php
session_start();
include('include/config.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['id'])) {
    header('location:logout.php');
    exit();
}

// helper function for safe htmlentities
function e($value)
{
    return htmlentities($value ?? '', ENT_QUOTES, 'UTF-8');
}
// =====================
// ACCEPT OR CANCEL APPOINTMENT
// =====================
if (isset($_GET['action']) && isset($_GET['id'])) {
    $appointmentId = intval($_GET['id']);
    $action = $_GET['action'];

    if ($action == "accept") {
        mysqli_query($con, "UPDATE appointment SET doctorStatus = 2 WHERE id = '$appointmentId'");
        $_SESSION['msg'] = "Appointment accepted successfully!";
    }

    if ($action == "cancel") {
        mysqli_query($con, "UPDATE appointment SET doctorStatus = 0 WHERE id = '$appointmentId'");
        $_SESSION['msg'] = "Appointment cancelled successfully!";
    }

    header("Location: appointment-history.php");
    exit();
}

// =====================
// DATE FILTER
// =====================
$from_date = !empty($_POST['from_date']) ? $_POST['from_date'] : '';
$to_date   = !empty($_POST['to_date']) ? $_POST['to_date'] : '';
$dateFilter = ($from_date && $to_date) ? " AND DATE(a.appointmentDate) BETWEEN '$from_date' AND '$to_date'" : "";

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Admin | All Appointments</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css" />
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css" />
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="assets/vendors/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" />
    <link rel="stylesheet" href="assets/css/style.css" />
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>
<style>
  .detailsModal {
    width: 60%;
  }
   
</style>
<body>
    <div class="container-scroller">
        <?php include('include/sidebar.php'); ?>

        <div class="container-fluid page-body-wrapper">
            <?php include('include/header.php'); ?>
            <div class="main-panel">
                <div class="content-wrapper">

                    <!-- PAGE TITLE -->
                    <section id="page-title">
                        <div class="row">
                            <div class="col-sm-8">
                                <h1 class="mainTitle">All Appointments</h1>
                            </div>
                        </div>
                    </section>

                    <!-- Date Filter -->
                    <div class="container-fluid container-fullw bg-white">
                        <?php
                        if (isset($_SESSION['msg'])) {
                            echo '<div class="alert alert-info">' . htmlentities($_SESSION['msg']) . '</div>';
                            unset($_SESSION['msg']);
                        }
                        ?>
                        <form method="post" class="form-inline mt-3">
                            <label class="mr-2">From:</label>
                            <input type="date" name="from_date" class="form-control mr-3" value="<?= $from_date; ?>">
                            <label class="mr-2">To:</label>
                            <input type="date" name="to_date" class="form-control mr-3" value="<?= $to_date; ?>">
                            <button type="submit" class="btn btn-primary">Filter</button>
                            <a href="appointment-history.php" class="btn btn-danger ml-2">Reset</a>
                        </form>

                        <!-- Appointment Table -->
                        <div class="row">
                            <div class="col-md-12">
                                <table id="appointmentTable" class="table table-striped table-bordered">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Patient Name</th>
                                            <th>Doctor Name</th>
                                            <th>Reason</th>
                                            <th>Date & Time</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $query = mysqli_query($con, "
                                    SELECT a.*, 
                                           u.fullName AS patientName, u.mobile_no, u.email, 
                                           u.address, u.city, u.pincode, u.age, a.reason,
                                           d.doctorName
                                    FROM appointment a
                                    JOIN users u ON u.id = a.userId 
                                    JOIN doctors d ON d.id = a.doctorId
                                    WHERE 1=1 $dateFilter
                                    ORDER BY a.appointmentDate DESC, a.appointmentTime ASC
                                ");

                                        if (mysqli_num_rows($query) == 0) {
                                            echo "<tr><td colspan='6' class='text-center text-danger'>No appointments found.</td></tr>";
                                        } else {
                                            while ($row = mysqli_fetch_assoc($query)) {
                                                if ($row['userStatus'] == 1 && $row['doctorStatus'] == 1) $status = "⏳ Pending";
                                                elseif ($row['userStatus'] == 0 && $row['doctorStatus'] == 1) $status = "❌ Cancelled by Patient";
                                                elseif ($row['doctorStatus'] == 0) $status = "❌ Cancelled by Doctor";
                                                elseif ($row['doctorStatus'] == 2) $status = "✅ Accepted by Doctor";
                                                else $status = "❌ Cancelled";

                                                echo "<tr>
                                                        <td>" . e($row['patientName']) . "</td>
                                                        <td>" . e($row['doctorName']) . "</td>
                                                        <td>" . e($row['reason']) . "</td>
                                                        <td>" . e($row['appointmentDate']) . " " . e($row['appointmentTime']) . "</td>
                                                        <td>" . e($status) . "</td>
                                                        <td>";

                                                if ($row['userStatus'] == 1 && $row['doctorStatus'] == 1) {
                                                    echo "<a href='appointment-history.php?action=accept&id=" . $row['id'] . "' class='btn btn-success btn-sm' onclick=\"return confirm('Accept this appointment?');\">Accept</a> ";
                                                    echo "<a href='appointment-history.php?action=cancel&id=" . $row['id'] . "' class='btn btn-danger btn-sm' onclick=\"return confirm('Cancel this appointment?');\">Cancel</a>";
                                                } elseif ($row['doctorStatus'] == 2) {
                                                    echo "<span class='badge badge-success'>Accepted</span>";
                                                } elseif ($row['doctorStatus'] == 0) {
                                                    echo "<span class='badge badge-danger'>Cancelled</span>";
                                                } else {
                                                    echo "<span class='badge badge-secondary'>Inactive</span>";
                                                }

                                                echo " 
                                                    <button
                                                        class='btn btn-info btn-sm view-details'
                                                        data-toggle='modal'
                                                        data-target='#detailsModal'
                                                        data-patientid='" . $row['userId'] . "'
                                                        data-patient='" . e($row['patientName']) . "'
                                                        data-doctor='" . e($row['doctorName']) . "'
                                                        data-email='" . e($row['email']) . "'
                                                        data-mobile='" . e($row['mobile_no']) . "'
                                                        data-address='" . e($row['address']) . "'
                                                        data-city='" . e($row['city']) . "'
                                                        data-pincode='" . e($row['pincode']) . "'
                                                        data-age='" . e($row['age']) . "'
                                                        data-reason='" . e($row['reason']) . "'
                                                        data-date='" . e($row['appointmentDate']) . "'
                                                        data-time='" . e($row['appointmentTime']) . "'
                                                        data-status='" . e($status) . "'
                                                    >
                                                        View
                                                    </button>
                                                </td></tr>";
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Details Modal -->
                    <div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header bg-primary text-white">
                                    <h5 class="modal-title">Appointment & Prescription Details</h5>
                                    <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <h5>Appointment Info</h5>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Patient Name</th>
                                            <td id="dPatient"></td>
                                        </tr>
                                        <tr>
                                            <th>Doctor Name</th>
                                            <td id="dDoctor"></td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td id="dEmail"></td>
                                        </tr>
                                        <tr>
                                            <th>Mobile</th>
                                            <td id="dMobile"></td>
                                        </tr>
                                        <tr>
                                            <th>Address</th>
                                            <td id="dAddress"></td>
                                        </tr>
                                        <tr>
                                            <th>City</th>
                                            <td id="dCity"></td>
                                        </tr>
                                        <tr>
                                            <th>Pincode</th>
                                            <td id="dPincode"></td>
                                        </tr>
                                        <tr>
                                            <th>Age</th>
                                            <td id="dAge"></td>
                                        </tr>
                                        <tr>
                                            <th>Reason</th>
                                            <td id="dReason"></td>
                                        </tr>
                                        <tr>
                                            <th>Date</th>
                                            <td id="dDate"></td>
                                        </tr>
                                        <tr>
                                            <th>Time</th>
                                            <td id="dTime"></td>
                                        </tr>
                                        <tr>
                                            <th>Status</th>
                                            <td id="dStatus"></td>
                                        </tr>
                                    </table>

                                    <h5 class="mt-4">Prescription Info</h5>
                                    <div id="prescriptionDetails">Loading...</div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <?php include('include/footer.php'); ?>

            </div>
        </div>
    </div>

    <!-- JS Libraries -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
  <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
  <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

  <script>
    
    $(document).ready(function() {
  $('#appointmentTable').DataTable({
    "paging": true,
    "lengthChange": true,
    "searching": true,
    "ordering": true,
    "info": true,
    "autoWidth": false,
    "pageLength": 10,
    "lengthMenu": [
      [5, 10, 25, 50, -1],
      [5, 10, 25, 50, "All"]
    ],
    // 👇 Layout fix for "Show entries" left, "Search" right
    "dom":
      '<"row mb-3"' +
        '<"col-sm-6 d-flex align-items-center"l>' +
        '<"col-sm-6 d-flex justify-content-end"f>' +
      '>' +
      'rt' +
      '<"row mt-3"' +
        '<"col-sm-6"i>' +
        '<"col-sm-6 d-flex justify-content-end"p>' +
      '>'
  });
});

  </script>
</body>

</html>