<?php
include("../connection.php");
include("../user.php");
// error_reporting(E_ALL);
// ini_set('display_errors', 1);
$editid = intval($_POST['editid']); // Secure the input

$repair_query = mysqli_query($con, "
    SELECT rm.*, vm.vendor_name, am.description, rm.vendor_name AS repair_vendor
    FROM repair_master rm 
    JOIN vendor_master vm ON rm.vendor_name = vm.id 
    JOIN asset_master am ON am.id = rm.asset_id 
    WHERE rm.id = $editid
");

$result = mysqli_fetch_array($repair_query);
?>
<!doctype html>
<html class="no-js" lang="">

<head>
    <meta charset="utf-8">
    <title><?php echo TITLE; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="../images/bluebase.png">
    <style>
        input, textarea, select {
            text-transform: uppercase;
        }
    </style>
</head>

<body>
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <strong>Edit Repair</strong>
                <a href="repair.php">
                    <button class="btn btn-primary" style="width:50px;float:right;">
                        <i class="fa fa-backward"></i>
                    </button>
                </a>
            </div>
            <div class="card-body card-block">
                <form method="post" enctype="multipart/form-data" class="form-horizontal" action="repair_update.php">
                    <input type="hidden" name="edit_id" value="<?php echo $editid; ?>">

                    <!-- Asset Select -->
                    <div class="row form-group" id="asset_set">
                        <div class="col col-md-3"><label class="form-control-label">Asset ID</label></div>
                        <div class="col-12 col-md-9">
                            <select id="asset_code" name="asset_code" onchange="asse_code(this.value)"
                                    class="form-control select-search" disabled>
                                <option value="" disabled>Select Asset Code</option>
                                <?php
                                $asset_id = mysqli_query($con, "SELECT * FROM `asset_master`");
                                while ($asset = mysqli_fetch_array($asset_id)) { ?>
                                    <option value="<?php echo $asset['id']; ?>" <?php if ($asset['id'] == $result['asset_id']) echo "selected"; ?>>
                                        <?php echo $asset['description']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                    <!-- Location -->
                    <div class="row form-group">
                        <div class="col col-md-3"><label class="form-control-label">Location</label></div>
                        <div class="col-12 col-md-9">
                            <input type="text" name="location" id="location" class="form-control" readonly
                                   value="<?php echo $result['location']; ?>">
                        </div>
                    </div>

                    <!-- Priority -->
                    <div class="row form-group">
                        <div class="col col-md-3"><label class="form-control-label">Priority</label></div>
                        <div class="col-12 col-md-9">
                            <select name="priority" class="form-control">
                                <option value="">SELECT PRIORITY</option>
                                <option value="High" <?php if ($result['priority'] == "High") echo "selected"; ?>>High</option>
                                <option value="Medium" <?php if ($result['priority'] == "Medium") echo "selected"; ?>>Medium</option>
                                <option value="Low" <?php if ($result['priority'] == "Low") echo "selected"; ?>>Low</option>
                            </select>
                        </div>
                    </div>

                    <!-- Vendor -->
                    <div class="row form-group">
                        <div class="col col-md-3"><label class="form-control-label">Vendor Name</label></div>
                        <div class="col-12 col-md-9">
                            <select id="vendor_det" name="vendor_det" class="form-control select-search">
                                <option value="">Select Vendor</option>
                                <?php
                                $vendors = mysqli_query($con, "SELECT * FROM `vendor_master` WHERE status = 0");
                                while ($vendor = mysqli_fetch_array($vendors)) { ?>
                                    <option value="<?php echo $vendor['id']; ?>" <?php if ($vendor['id'] == $result['repair_vendor']) echo "selected"; ?>>
                                        <?php echo $vendor['vendor_name'] . '-' . $vendor['vendor_address']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                    <!-- Send on -->
                    <div class="row form-group">
                        <div class="col col-md-3"><label class="form-control-label">Send on</label></div>
                        <div class="col-12 col-md-9">
                            <input type="date" name="submit_dates" class="form-control"
                                   value="<?php echo $result['sendon']; ?>">
                        </div>
                    </div>

                    <!-- Expected Return Date -->
                    <div class="row form-group">
                        <div class="col col-md-3"><label class="form-control-label">Expect Return Date</label></div>
                        <div class="col-12 col-md-9">
                            <input type="date" name="expect_date" class="form-control"
                                   value="<?php echo $result['expect_return_date']; ?>">
                        </div>
                    </div>

                    <!-- Remarks -->
                    <div class="row form-group">
                        <div class="col col-md-3"><label class="form-control-label">Repair Remarks</label></div>
                        <div class="col-12 col-md-9">
                            <textarea name="remarks" class="form-control"><?php echo $result['remarks']; ?></textarea>
                        </div>
                    </div>

                    <!-- Submit -->
                    <div>
                        <button type="submit" name="submit" class="btn btn-success" style="float:right;">
                            <i class="fa fa-inbox"></i> Submit
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</body>
<script>
	// Initialize Select2 and fetch default asset location onload
	$(document).ready(function () {
		$('.select-search').select2({
			placeholder: "-- SELECT --",
			allowClear: true
		});
		if ($('#asset_code').val()) {
    asse_code($('#asset_code').val());
}

	});

	function asse_code(asset_id) {
		if (asset_id !== '') {
			$.ajax({
				url: "get_asset_details.php",
				type: "POST",
				data: { id: asset_id },
				success: function (response) {
					let data = JSON.parse(response);
					$('#location').val(data.location);
				},
				error: function (xhr, status, error) {
					console.error("AJAX Error:", status, error);
					alert('Something went wrong. Could not fetch asset details.');
				}
			});
		}
	}

</script>
</html>
