<?php
include("../connection.php");
include("../user.php");

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $material_name = strtoupper(trim($_POST['material']));
    $material_description = strtoupper(trim($_POST['prefix']));
    $measurement_type =$_POST['measurement_type'];
    $measurement = '';
    $user = $_SESSION['user'];
    $cur_date = date('Y-m-d H:i:s');

    // New fields
    $department =$_POST['department'];
    $area =$_POST['area'];
    $block =$_POST['block'];
    $no_of_staff =$_POST['no_of_staff']; // Ensure it's a valid integer
    $performance_job =$_POST['performance_job'];
    $qty_requested =$_POST['qty_requested'];
    $qty_issued =$_POST['qty_issued'];
    $requested_by =$_POST['requested_by'];
    $location_get = $_POST['location'];

// Debugging: check values before binding
echo "Requested By: $requested_by\n";
echo "Location: $location_get\n";
    // Determine which measurement input to use based on the selected type
    switch ($measurement_type) {
        case 'kg':
            $measurement = trim($_POST['kg']);
            break;
        case 'meter':
            $measurement = trim($_POST['meter']);
            break;
        case 'unit':
            $measurement = trim($_POST['unit']);
            break;
        default:
            $measurement = '';
    }

    // Validate that required fields are not empty
    if (empty($material_name) || empty($material_description) || empty($measurement_type) || empty($measurement) || empty($department) || empty($area) || empty($block) || $no_of_staff <= 0 || empty($performance_job) || $qty_requested <= 0 || $qty_issued < 0 || empty($requested_by) || empty($location_get)) {
        echo "<script>alert('All fields are required. Please fill out the form correctly.'); window.location.href='material_request.php';</script>";
        exit();
    }

   // Prepare and execute the SQL statement
$stmt = $con->prepare("INSERT INTO material_request 
(material_name, material_description, measurement_type, measurement, 
department, area, block, no_of_staff, performance_job, 
qty_requested, qty_issued, requested_by, location, sts, created_by, created_on) 
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, ?, ?)");

if (!$stmt) {
echo "Error in SQL preparation: " . $con->error;
exit();
}

// Bind parameters
$stmt->bind_param("sssssssissssiss", 
$material_name, 
$material_description, 
$measurement_type, 
$measurement, 
$department, 
$area, 
$block, 
$no_of_staff, 
$performance_job, 
$qty_requested, 
$qty_issued, 
$requested_by, 
$location_get, 
$user, 
$cur_date);



    if ($stmt->execute()) {
       //    echo "<script>alert('Material request submitted successfully!'); window.location.href='material_master.php';</script>";
    } else {
        echo "<script>alert('Failed to submit material request. Please try again.'); window.location.href='material_request.php';</script>";
    }

    $stmt->close();
    $con->close();
} else {
    header("Location: material_request.php");
    exit();
}
?>
