<?php
include("../connection.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Only category_type data
$category_types = [
    "Convex Mirror 32\"", "Car Wheel Lock", "Hardwyn Telecop 20\"", "Silicon 280ml"
];

// Get the last category_id
$res = $con->query("SELECT MAX(CAST(SUBSTRING(category_id, 4) AS UNSIGNED)) AS last_id FROM category_master");
$row = $res->fetch_assoc();
$last_id = (int)$row['last_id'];
$counter = $last_id + 1;

foreach ($category_types as $type) {
    $type = trim($type);

    if (empty($type)) continue;

    // Check if category_type already exists (case-insensitive)
    $stmt = $con->prepare("SELECT 1 FROM category_master WHERE LOWER(category_type) = LOWER(?) LIMIT 1");
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->close();
        echo "⚠️ Skipped (already exists): $type<br>";
        continue;
    }
    $stmt->close();

    // Insert into category_master (without department)
    $new_id = sprintf("mt-%04d", $counter);
    $ins = $con->prepare("INSERT INTO category_master (category_id, category_type) VALUES (?, ?)");
    $ins->bind_param("ss", $new_id, $type);
    $ins->execute();
    $ins->close();

    echo "✅ Inserted: $new_id - $type<br>";
    $counter++;
}

$con->close();
?>
