<?php
include("../connection.php");
include("../user.php");
$cur_date = date('Y-m-d H:i:s');
$user = $_SESSION['user'];
$branch_id = $_SESSION['branch_id'];
$ho_access = $_SESSION['ha'];

function getNextVendorCode($con)
{
	$query = "SELECT MAX(vendor_code) AS vendor_code FROM vendor_master ORDER BY id DESC LIMIT 1";
	$result = mysqli_query($con, $query);

	if (!$result) {
		die("Query failed: " . mysqli_error($con));
	}

	if ($row = mysqli_fetch_assoc($result)) {
		$lastCode = $row['vendor_code'];
		$lastNumber = (int)substr($lastCode, 4); // Get the numeric part
		$newNumber = $lastNumber + 1;
		return "VEN-" . str_pad($newNumber, 2, "0", STR_PAD_LEFT); // Generate new code
	} else {
		return "VEN-01"; // Default if no records found
	}
}

$vendorCode = getNextVendorCode($con);
?>
<!doctype html>
<html class="no-js" lang="">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title><?php echo TITLE; ?></title>
	<meta name="description" content="Ela Admin - HTML5 Admin Template">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="apple-touch-icon" href="../images/bluebase.png">
	<link rel="shortcut icon" href="../images/bluebase.png">
	<!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

	<style>
		input {
			text-transform: uppercase;
		}

		textarea {
			text-transform: uppercase;
		}

		select {
			text-transform: uppercase;
		}
	</style>
	<script>
		function validateGST() {
			var gst = document.getElementById("gst_number").value;
			var gstPattern = /^[A-Z0-9]{15}$/; // Adjusted to 15 characters

			if (!gstPattern.test(gst)) {
				alert("Please enter a valid 15-character GST number.");
				return false;
			}
			return true;
		}
	</script>
</head>

<body>
	<div class="col-lg-8">
		<div class="card">
			<div class="card-header">
				<strong>Vendor Creation</strong>
				<a href="vendor_master.php"><button class="btn btn-primary" style="width:50px;margin-left:400px;" onclick=""><i class="fa fa-backward"></i></button></a>
			</div>
			<div class="card-body card-block">
				<!-- <form method="post" enctype="multipart/form-data" class="form-horizontal" action="vendor_submit.php" onsubmit="return validateGST()"> -->
				<form method="post" enctype="multipart/form-data" class="form-horizontal" action="vendor_submit.php">
					<?php
					if ($ho_access == "yes") {
					?>
						
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor Code</label></div>
							<div class="col-12 col-md-9"><input type="text" id="vendor_code" name="vendor_code" class="form-control" value="<?php echo $vendorCode; ?>" readonly></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor Name</label><span style="color:red;">*</span></div>
							<div class="col-12 col-md-9"><input type="text" id="vendor_name" name="vendor_name" placeholder="Enter vendor name" class="form-control" onchange="vendor_val(this.value)" autocomplete="off" required></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Department</label></div>
							<div class="col-12 col-md-9"><select id="department" name="department" placeholder="select Department" class="form-control select-search" autocomplete="off">
									<option value="" selected disabled>Select Department</option>
									<?php
									$brn = mysqli_query($con, "SELECT * FROM type_master where  status='0' order by id asc");
									while ($brc = mysqli_fetch_array($brn)) {
									?>
										<option value="<?php echo $brc['type']; ?>"><?php echo strtoupper($brc['type']); ?></option>
									<?php
									}
									?>
								</select></div>
						</div>

						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor Address</label></div>
							<div class="col-12 col-md-9"><textarea id="vendor_addr" name="vendor_addr" class="form-control" placeholder="Enter vendor address" autocomplete="off"></textarea></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Phone</label></div>
							<div class="col-12 col-md-9"><input type="text" id="phone" name="phone" placeholder="Enter Phone number" class="form-control" autocomplete="off" ></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">E-Mail</label></div>
							<div class="col-12 col-md-9"><input type="email" id="email" name="email" placeholder="Enter E-mail Id" class="form-control" autocomplete="off" ></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Contact Person</label></div>
							<div class="col-12 col-md-9"><input type="text" id="contact" name="contact" placeholder="Enter Contact person" class="form-control" autocomplete="off" ></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="gst_number" class="form-control-label">GST Number</label></div>
							<div class="col-12 col-md-9"><input type="text" id="gst_number" name="gst_number" class="form-control"></div>
						</div>
					<?php
					} else {
					?>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor Code</label></div>
							<div class="col-12 col-md-9"><input type="text" id="vendor_code" name="vendor_code" class="form-control" value="<?php echo $vendorCode; ?>" readonly></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor Name</label><span style="color:red;">*</span></div>
							<div class="col-12 col-md-9"><input type="text" id="vendor_name" name="vendor_name" placeholder="Enter vendor name" class="form-control" onchange="vendor_val(this.value)" autocomplete="off" required></div>
						</div>

						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Vendor Address</label></div>
							<div class="col-12 col-md-9"><textarea id="vendor_addr" name="vendor_addr" class="form-control" placeholder="Enter vendor address" autocomplete="off"></textarea></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Phone</label></div>
							<div class="col-12 col-md-9"><input type="text" id="phone" name="phone" placeholder="Enter Phone number" class="form-control" autocomplete="off" ></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">E-Mail</label></div>
							<div class="col-12 col-md-9"><input type="email" id="email" name="email" placeholder="Enter E-mail Id" class="form-control" autocomplete="off" ></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="text-input" class=" form-control-label">Contact Person</label></div>
							<div class="col-12 col-md-9"><input type="text" id="contact" name="contact" placeholder="Enter Contact person" class="form-control" autocomplete="off"></div>
						</div>
						<div class="row form-group">
							<div class="col col-md-3"><label for="gst_number" class="form-control-label">GST Number</label></div>
							<div class="col-12 col-md-9"><input type="text" id="gst_number" name="gst_number" class="form-control"></div>
						</div>
					<?php
					}
					?>

					<div style="">
						<button type="submit" name="submit" class="btn btn-success"><i class="fa fa-dot-circle-o"></i> Submit</button>

					</div>
				</form>
			</div>
		</div>
		<div class="clearfix"></div>

		<footer class="site-footer">

		</footer>

	</div><!-- /#right-panel-->
	<script>
        // Initialize Select2
        $(document).ready(function() {
            $('.select-search').select2({
                placeholder: "-- SELECT --",  // Optional placeholder text
                allowClear: true                // Optional: allows clearing the selection
            });
        });
    </script>
</body>

</html>